/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.modbus;

import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.pin.PinObserver;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import com.ur.view.modbus.ModbusSignal;
import java.util.Vector;
import javax.inject.Inject;

public class ModbusUnit {
    private String ip_address;
    private Vector<ModbusSignal> modbusSignals;
    private boolean sequentialModeFlag;

    @Inject
    private ModbusUnit() {
    }

    public ModbusUnit(String ip) {
        this.ip_address = ip;
        this.modbusSignals = new Vector();
        this.modbusSignals.clear();
    }

    public String getIP() {
        return this.ip_address;
    }

    public void setIP(String IP) {
        if (this.ip_address.equals(IP) || IP.equals("0.0.0.0")) {
            return;
        }
        this.ip_address = IP;
        this.startSignalConnectionsAtUnit();
        this.notifyChangeOccurred();
    }

    public Vector<ModbusSignal> getSignals() {
        for (ModbusSignal each : this.modbusSignals) {
            each.setModbusUnit(this);
        }
        return this.modbusSignals;
    }

    public void addSignal(final ModbusSignal ms) {
        this.modbusSignals.add(ms);
        EventNotificationService.notify(PinObserver.class, (NotificationStrategy)new NotificationStrategy<PinObserver>(){

            public void notify(PinObserver listener) {
                listener.added((Pin)ms);
            }
        });
        this.notifyChangeOccurred();
    }

    public void removeSignal(final ModbusSignal ms) {
        ms.stopSignalConnection();
        this.modbusSignals.remove(ms);
        EventNotificationService.notify(PinObserver.class, (NotificationStrategy)new NotificationStrategy<PinObserver>(){

            public void notify(PinObserver listener) {
                listener.removed((Pin)ms);
            }
        });
        this.notifyChangeOccurred();
    }

    public void setSequentialModeFlag(boolean sequentialModeFlag) {
        if (sequentialModeFlag == this.sequentialModeFlag) {
            return;
        }
        this.sequentialModeFlag = sequentialModeFlag;
        this.startSignalConnectionsAtUnit();
        this.notifyChangeOccurred();
    }

    public boolean isSequentialModeFlag() {
        return this.sequentialModeFlag;
    }

    private void notifyChangeOccurred() {
        EventNotificationService.notify(InstallationStateListener.class, (NotificationStrategy)new NotificationStrategy<InstallationStateListener>(){

            public void notify(InstallationStateListener listener) {
                listener.installationModified();
            }
        });
    }

    public void startSignalConnectionsAtUnit() {
        for (ModbusSignal current : this.modbusSignals) {
            current.stopSignalConnection();
            current.startSignalConnection();
        }
    }
}

