/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.modbus;

import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.view.modbus.ModbusSignal;
import com.ur.view.modbus.ModbusUnit;

public class ModbusUnitConversionStrategy
extends ConversionStrategyTemplate<ModbusUnit> {
    private static final String IP_ADDRESS = "ipAddress";
    private static final String SEQUENTIAL_MODE = "sequentialMode";

    public ModbusUnitConversionStrategy() {
        super(ModbusUnit.class);
    }

    public void marshal(ModbusUnit unit, PersistWriter writer) {
        writer.addAttribute(IP_ADDRESS, unit.getIP());
        writer.addAttribute(SEQUENTIAL_MODE, unit.isSequentialModeFlag());
        for (ModbusSignal each : unit.getSignals()) {
            writer.writeNodeWithTypeAndValue("ModbusSignal", (Object)each);
        }
    }

    public ModbusUnit unmarshal(PersistReader reader) {
        ModbusUnit result = null;
        if (reader.isNode("modbusUnits")) {
            result = this.pre_3_1(reader);
        } else {
            result = new ModbusUnit(reader.getStringAttribute(IP_ADDRESS));
            result.setSequentialModeFlag(reader.getBooleanAttribute(SEQUENTIAL_MODE));
            while (reader.hasMoreNodes()) {
                result.addSignal((ModbusSignal)reader.convertContainedValue(ModbusSignal.class));
            }
        }
        return result;
    }

    private ModbusUnit pre_3_1(PersistReader reader) {
        ModbusUnit result = null;
        reader.moveToChildNode();
        while (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            if (reader.getNodeName().startsWith("ip")) {
                result = new ModbusUnit(reader.getStringValue());
            } else if (reader.isNode("modbusSignals")) {
                while (reader.hasMoreNodes()) {
                    reader.moveToChildNode();
                    result.addSignal((ModbusSignal)reader.convertContainedValue((Object)result, ModbusSignal.class));
                    reader.moveToParentNode();
                }
            }
            reader.moveToParentNode();
        }
        reader.moveToParentNode();
        return result;
    }
}

