/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.modbus;

import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.persistence.ConversionStrategy;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.pin.PersistIOPart;
import com.ur.polyscope.pin.service.IOService;
import com.ur.view.modbus.ModbusComponent;
import com.ur.view.modbus.ModbusInterface;
import com.ur.view.modbus.ModbusUnit;
import com.ur.view.modbus.ModbusUnitConversionStrategy;

class PersistModbusPart
implements PersistIOPart {
    private static final String MODBUS_UNITS = "ModbusUnits";

    PersistModbusPart() {
    }

    public void marshal(IOService toMarshal, Installation installation, PersistWriter writer) {
        writer.startNode(MODBUS_UNITS);
        for (ModbusUnit each : ((ModbusComponent)installation.getComponent(ModbusComponent.class)).getModbusInterface()) {
            writer.startNode("Unit");
            writer.writeContainedValue((Object)each, (ConversionStrategy)new ModbusUnitConversionStrategy());
            writer.endNode();
        }
        writer.endNode();
    }

    public void unmarshal(Installation installation, PersistReader reader) {
        if (reader.isNode(MODBUS_UNITS)) {
            ModbusInterface modbusInterface = ((ModbusComponent)installation.getComponent(ModbusComponent.class)).getModbusInterface();
            modbusInterface.clear();
            while (reader.hasMoreNodes()) {
                reader.moveToChildNode();
                modbusInterface.addUnit((ModbusUnit)reader.convertContainedValue(ModbusUnit.class));
                reader.moveToParentNode();
            }
        }
    }

    public boolean canUnmarshal(PersistReader reader) {
        return reader.isNode(MODBUS_UNITS);
    }
}

