/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.modbus;

import com.ur.i18n.TextResource;
import com.ur.lang.PrimitiveUtils;
import com.ur.polyscope.program.ProgramModeHolder;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.units.ValueConverter;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.view.modbus.AbstractModbusSignalIOControlView;
import com.ur.view.modbus.ModbusSignal;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class RegisterOutputModbusSignalIOControlView
extends AbstractModbusSignalIOControlView
implements ActionListener {
    private static final int MODBUS_REGISTER_VALUE_MAX = 65535;
    private NumberField signalValueField;
    private long timeWhenPressed;
    private boolean ignoreUpdatesForOutputRegister;
    private TextResource textResource;

    RegisterOutputModbusSignalIOControlView(ModbusSignal signal, ProgramModeHolder programModeService, ViewContext view) {
        super(signal, programModeService);
        WidgetFactory widgetFactory = view.createWidgetFactory();
        URFontFactory fontFactory = view.getFontFactory();
        this.signalValueField = widgetFactory.createNumberField((ActionListener)this);
        this.signalValueField.setValueConverter((ValueConverter)ValueConverter.INTEGER_CONVERTER);
        this.signalValueField.setFont(fontFactory.getRelativeFont(URFontFactory.Size.MEDIUM));
        this.textResource = (TextResource)view.getTextResource(TextResource.class);
    }

    @Override
    public AbstractModbusSignalIOControlView initComponents() {
        super.initComponents();
        this.signalValueField.setUnitWidth(0);
        this.signalValueField.setHorizontalAlignment(4);
        this.signalValueField.setMode(Mode.PositiveWholeNumbers);
        String outOfBoundsOutputRegisterErrorMessage = this.textResource.wholeNumberOutOfRange(0L, "", 65535L);
        this.signalValueField.setErrorValidationStrategy(new ValidationStrategy[]{ValidationFactory.getRangeValidator((double)0.0, (double)65535.0, (boolean)true, (String)outOfBoundsOutputRegisterErrorMessage)});
        this.signalValueField.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                RegisterOutputModbusSignalIOControlView.this.ignoreUpdatesForOutputRegister = true;
            }
        });
        this.add(this.connectionStatusIcon);
        this.add((Component)this.signalValueField);
        this.add(this.name);
        this.signalValueField.setEnabled(this.canControlSignal());
        return this;
    }

    @Override
    public void updatePanel() {
        long t = System.currentTimeMillis();
        if (t - this.timeWhenPressed > 200L && !this.ignoreUpdatesForOutputRegister) {
            super.updatePanel();
            this.signalValueField.setText(Integer.toString(this.signalValue));
            this.signalValueField.setEnabled(this.canControlSignal());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.timeWhenPressed = System.currentTimeMillis();
        int out = PrimitiveUtils.parseInteger((String)this.signalValueField.getText(), (int)this.modbusSignal.getValue());
        this.modbusSignal.sendModbusOutputRegisterValue(out);
        this.ignoreUpdatesForOutputRegister = false;
    }

    @Override
    public void setWidthOfSignalValueField(int width) {
        this.signalValueField.setMinimumSize(new Dimension(width, 28));
        this.signalValueField.setPreferredSize(new Dimension(width, 28));
        this.signalValueField.setMaximumSize(new Dimension(width, 28));
    }
}

