/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.naming;

import com.ur.injection.ChainingInterceptor;
import com.ur.lang.ClassUtils;
import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamingService;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.reversible.UndoRedoService;
import gui.program.ProgramUndoRedoService;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class NameChangeInterceptor
extends ChainingInterceptor {
    private final Class<? extends Annotation> nameChangeTag;
    private UndoRedoService<AbstractProgramNode> undoRedo;
    private NamingService namingService;
    private boolean intercepting;

    public NameChangeInterceptor(Class<? extends Annotation> nameChangeTag, MethodInterceptor next) {
        super(next);
        this.nameChangeTag = nameChangeTag;
        this.intercepting = false;
    }

    @Inject
    public void setUndoRedoService(ProgramUndoRedoService undoRedo) {
        this.undoRedo = undoRedo;
    }

    @Inject
    public void setNamingService(NamingService namingService) {
        this.namingService = namingService;
    }

    protected boolean shouldProcess(MethodInvocation invocation) {
        return !this.intercepting && ClassUtils.hasAnnotation((Object)invocation.getMethod(), this.nameChangeTag);
    }

    protected Object process(MethodInvocation invocation) throws Throwable {
        try {
            this.intercepting = true;
            Object invocationTarget = invocation.getThis();
            Object[] arguments = invocation.getArguments();
            if (invocationTarget instanceof NamedEntity && arguments.length > 0 && arguments[0] instanceof String) {
                NamedEntity entity = (NamedEntity)invocationTarget;
                String nameCandidate = (String)arguments[0];
                if (this.undoRedo.isUndoingOrRedoing()) {
                    String oldName = entity.getName();
                    Object result = invocation.proceed();
                    this.namingService.updateName(entity, oldName, entity.getName());
                    Object object = result;
                    return object;
                }
                this.namingService.setNameOfEntity(entity, nameCandidate);
                return null;
            }
            Object object = invocation.proceed();
            return object;
        }
        finally {
            this.intercepting = false;
        }
    }
}

