/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.polyscope.controllerinterface.robotmessage.impl;

import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.log.logentry.robotmessage.RobotMessageConsumer;
import com.ur.monitor.RobotState;
import com.ur.polyscope.controllerinterface.MessageConsumer;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.util.logging.Log;
import com.ur.view.constants.comm.MessageType;
import com.ur.view.constants.comm.RobotMessageType;
import com.ur.view.constants.errorcodes.MessageSource;
import com.ur.view.polyscope.controllerinterface.robotmessage.EditRobotState;
import gui.tools.DialogCreator;
import java.io.DataInput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;

public class RobotMessageMessageConsumer
implements MessageConsumer {
    private final Map<RobotMessageType, RobotMessageConsumer> robotMessageConsumers;
    private Set<RobotMessageType> unknownTypes = new HashSet<RobotMessageType>();
    private Set<RobotMessageType> typesWithWrongMessageLength = new HashSet<RobotMessageType>();
    private DialogCreator dialogCreator;

    @Inject
    public RobotMessageMessageConsumer(Map<RobotMessageType, RobotMessageConsumer> robotMessageConsumerSet, DialogCreator dialogCreator) {
        this.robotMessageConsumers = robotMessageConsumerSet;
        this.dialogCreator = dialogCreator;
    }

    public void initialize(RobotState robotStateToEditHere) {
        for (RobotMessageConsumer each : this.robotMessageConsumers.values()) {
            if (!(each instanceof EditRobotState)) continue;
            ((EditRobotState)each).initialize(robotStateToEditHere);
        }
    }

    public MessageType getPackageType() {
        return MessageType.ROBOT_MESSAGE;
    }

    public int consume(DataInput dataInputStream, int messageLength) throws IOException {
        RobotMessage robotMessage = new RobotMessage();
        robotMessage.timestamp = dataInputStream.readLong();
        robotMessage.source = MessageSource.byId((int)dataInputStream.readByte());
        robotMessage.type = RobotMessageType.byId((int)dataInputStream.readByte());
        int messageOffset = 10;
        if (this.robotMessageConsumers.containsKey(robotMessage.type)) {
            RobotMessageConsumer consumer = this.robotMessageConsumers.get(robotMessage.type);
            messageOffset += consumer.consume(dataInputStream, messageLength - messageOffset, robotMessage);
            if (consumer.sendNotification()) {
                this.sendNotification(robotMessage);
            }
        } else {
            this.logUnknownTypes(robotMessage.type);
            dataInputStream.skipBytes(messageLength - messageOffset);
            messageOffset = messageLength;
        }
        if (messageLength != messageOffset) {
            this.handleWrongMessageLength(messageLength, messageOffset, robotMessage.type);
            messageOffset = messageLength;
        }
        return messageOffset;
    }

    private void handleWrongMessageLength(int expected, int actual, RobotMessageType type) {
        if (!this.typesWithWrongMessageLength.contains(type)) {
            String errorMessage = type + ": failed to parse full message, expected " + expected + ", but was " + actual;
            Log.error((String)errorMessage);
            this.dialogCreator.showErrorDialog(new ErrorMessage("Wrong message length", errorMessage), new OkDialogListener());
            this.typesWithWrongMessageLength.add(type);
        }
    }

    private void logUnknownTypes(RobotMessageType type) {
        if (!this.unknownTypes.contains(type)) {
            String errorMessage = "Unsupported RobotMessageType package type: " + type;
            Log.error((String)errorMessage);
            this.dialogCreator.showErrorDialog(new ErrorMessage("Unknown message type", errorMessage), new OkDialogListener());
            this.unknownTypes.add(type);
        }
    }

    private void sendNotification(RobotMessage robotMessage) {
        try {
            robotMessage.clearToStringCache();
            robotMessage.notifyAllSubscribers();
        }
        catch (Exception e) {
            Log.error((String)"RobotMessage.notifyAllSubscribers failed: ", (Throwable)e);
        }
    }
}

