/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.polyscope.controllerinterface.robotmessage.impl;

import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.log.logentry.robotmessage.RobotMessageConsumer;
import com.ur.util.logging.Log;
import java.io.DataInput;
import java.io.IOException;

public class VersionMessageConsumer
implements RobotMessageConsumer {
    public static final int BASE_MESSAGE_LENGTH = 11;

    public boolean sendNotification() {
        return true;
    }

    public int consume(DataInput stream, int messageLength, RobotMessage robotMessage) throws IOException {
        int projectNameLength = stream.readUnsignedByte();
        String projectName = VersionMessageConsumer.readMessage(stream, projectNameLength);
        int major = stream.readUnsignedByte();
        int minor = stream.readUnsignedByte();
        int bugfix = stream.readInt();
        int buildNumber = stream.readInt();
        String buildDate = VersionMessageConsumer.readMessage(stream, messageLength - (projectName.getBytes().length + 11));
        robotMessage.message = String.valueOf(projectName) + " " + major + "." + minor + "." + bugfix + "." + buildNumber;
        Log.info((String)robotMessage.message);
        return 11 + projectName.getBytes().length + buildDate.getBytes().length;
    }

    private static final String readMessage(DataInput input, int len) throws IOException {
        byte[] data = new byte[len];
        input.readFully(data, 0, len);
        return new String(data);
    }
}

