/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.polyscope.module.installation;

import com.ur.polyscope.persistence.ConversionStrategy;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.scriptwriter.ScriptGeneratorLookup;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.swing.CardPanel;
import com.ur.swing.FlipManager;
import com.ur.util.logging.Log;
import com.ur.view.polyscope.module.UIInstallationNode;
import com.ur.view.polyscope.module.UserToCardPanelProvider;
import com.ur.view.polyscope.module.installation.InstallationContributionsProvider;
import com.ur.view.polyscope.module.installation.InstallationModule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;

@Singleton
public class InstallationsContributionsProviderImpl
implements InstallationContributionsProvider,
UserToCardPanelProvider {
    private final Map<Class<?>, Class<? extends CardPanel>> userObjectToCardPanel = new HashMap();
    private final List<InstallationModule> modules = new ArrayList<InstallationModule>();
    private final Map<String, ConversionStrategy<?>> persistables = new HashMap();

    @Override
    public void registerModule(InstallationModule installationModule) {
        if (installationModule == null) {
            return;
        }
        this.modules.add(installationModule);
        this.persistables.put(installationModule.getModuleName(), installationModule);
    }

    @Override
    public void registerCardPanels(FlipManager flipManager) {
        for (InstallationModule each : this.modules) {
            each.registerCardPanel(flipManager);
            each.registerUserTypeToCardPanel(this);
        }
    }

    @Override
    public Class<? extends CardPanel> getCardTypeFrom(Object userObject) {
        if (userObject == null) {
            Log.debug((String)"UserObject in InstallationTab was null");
            return null;
        }
        return this.userObjectToCardPanel.get(userObject.getClass());
    }

    @Override
    public List<UIInstallationNode> getUIInstallationNodes() {
        ArrayList<UIInstallationNode> result = new ArrayList<UIInstallationNode>();
        for (InstallationModule module : this.modules) {
            result.addAll(module.getUIInstallationNodes());
        }
        return result;
    }

    @Override
    public Iterable<InstallationModule> getInstallationModules() {
        return this.modules;
    }

    @Override
    public void getUserTypeToCardPanel(Class<?> userObjectType, Class<? extends CardPanel> cardPanelType) {
        this.userObjectToCardPanel.put(userObjectType, cardPanelType);
    }

    @Override
    public void marshal(PersistWriter writer) {
        for (String each : this.persistables.keySet()) {
            writer.startNode(each);
            this.persistables.get(each).marshal(null, writer);
            writer.endNode();
        }
    }

    @Override
    public void unmarshal(PersistReader reader) {
        HashSet<String> persistablesEncountered = new HashSet<String>();
        while (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            String nodeName = reader.getNodeName();
            ConversionStrategy<?> conversionStrategy = this.persistables.get(nodeName);
            if (conversionStrategy != null) {
                persistablesEncountered.add(nodeName);
                conversionStrategy.unmarshal(reader);
            }
            reader.moveToParentNode();
        }
        for (String each : this.persistables.keySet()) {
            if (persistablesEncountered.contains(each)) continue;
            this.persistables.get(each).unmarshal(null);
        }
    }

    @Override
    public void clearData() {
        for (InstallationModule each : this.modules) {
            each.clearData();
        }
    }

    @Override
    public ScriptWriter generatePreambleScript(ScriptWriter writer, ScriptGeneratorLookup scriptGeneratorLookup) {
        for (InstallationModule each : this.modules) {
            each.generatePreambleScript(writer, scriptGeneratorLookup);
        }
        return writer;
    }

    @Override
    public Set<String> getUndefinedInstallationContributions() {
        LinkedHashSet<String> missed = new LinkedHashSet<String>();
        List<UIInstallationNode> nodes = this.getUIInstallationNodes();
        for (UIInstallationNode node : nodes) {
            if (!node.hasWarning()) continue;
            missed.add(node.toString());
        }
        return missed;
    }

    @Override
    public boolean hasUndefinedInstallationContribution() {
        return !this.getUndefinedInstallationContributions().isEmpty();
    }
}

