/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.polyscope.module.programs;

import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.view.polyscope.module.programs.ProgramContributionProvider;
import com.ur.view.polyscope.module.programs.ProgramModule;
import gui.polyscope.program.ProgramFactorySite;
import gui.program.ContributableProgramNode;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Singleton;

@Singleton
public class ProgramContributionProviderImpl
implements ProgramContributionProvider {
    private List<ProgramFactorySite> sites = new ArrayList<ProgramFactorySite>();
    private ProgramModule module;

    @Override
    public void registerModule(ProgramModule loadInterfaceToModule) {
        this.module = loadInterfaceToModule;
        if (!this.sites.isEmpty()) {
            for (ProgramFactorySite each : this.sites) {
                this.contributeToProgramFactory(each);
            }
            this.sites.clear();
        }
    }

    @Override
    public void contributeToProgramFactory(ProgramFactorySite site) {
        if (this.module == null) {
            this.sites.add(site);
        } else {
            for (ProgramModule.ContributableProgramNodeFactory contributableProgramNodeFactory : this.module.getContributions().values()) {
                site.addProgramNodeFactory(contributableProgramNodeFactory);
            }
        }
    }

    @Override
    public ContributableProgramNode unmarshal(PersistReader reader) {
        return this.module.unmarshal(reader);
    }

    @Override
    public void marshal(ContributableProgramNode node, PersistWriter writer) {
        this.module.marshal(node, writer);
    }
}

