/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.polyscope.persistence.installation;

import com.ur.injection.Builder;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationComponent;
import com.ur.polyscope.installation.InstallationComponentConversionStrategy;
import com.ur.polyscope.persistence.CompositeConversionStrategy;
import com.ur.polyscope.persistence.ConversionStrategy;
import com.ur.polyscope.persistence.Serialization;
import com.ur.polyscope.persistence.SerializationFacade;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.util.logging.Log;
import com.ur.view.modbus.ModbusSignal;
import com.ur.view.modbus.ModbusSignalConversionStrategy;
import com.ur.view.modbus.ModbusUnitConversionStrategy;
import com.ur.view.polyscope.persistence.installation.RobotInstallationConverterStrategy_v3_0;
import com.ur.view.polyscope.persistence.installation.RobotInstallationConverterStrategy_v3_1;
import com.ur.view.polyscope.persistence.installation.RobotInstallationUpgraderV1;
import com.ur.view.polyscope.persistence.installation.VersionConversionStrategy;
import com.ur.view.polyscope.persistence.installation.geom.BaseViewConversionStrategy;
import com.ur.view.polyscope.persistence.installation.geom.CameraViewConversionStrategy;
import com.ur.view.polyscope.persistence.installation.geom.GeomLineNodeConversionStrategy;
import com.ur.view.polyscope.persistence.installation.geom.GeomPlaneNodeConversionStrategy;
import com.ur.view.polyscope.persistence.installation.geom.GeomPoseNodeConversionStrategy;
import com.ur.view.polyscope.persistence.installation.geom.ToolViewConversionStrategy;
import com.ur.view.polyscope.persistence.installation.geom.WorldTransformConversionStrategy;
import com.ur.view.variables.core.Variable;
import gui.geom.BaseView;
import gui.geom.CameraView;
import gui.geom.ToolView;
import gui.geom.WorldTransform;
import gui.polyscope.setup.treenodes.geom.GeomLineNode;
import gui.polyscope.setup.treenodes.geom.GeomPlaneNode;
import gui.polyscope.setup.treenodes.geom.GeomPoseNode;
import gui.tools.PersistStrategy;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Set;
import javax.inject.Inject;

public class InstallationXMLPersistStrategy
implements PersistStrategy<Installation> {
    private final Builder builder;
    private final Set<InstallationComponentConversionStrategy> installationComponentConversionStrategySet;

    @Inject
    public InstallationXMLPersistStrategy(Builder builder, Set<InstallationComponentConversionStrategy> installationComponentConversionStrategySet) {
        this.builder = builder;
        this.installationComponentConversionStrategySet = installationComponentConversionStrategySet;
    }

    @Override
    public void marshal(Installation toMarshal, Writer writer) {
        Serialization marshaller = SerializationFacade.createMarshaller();
        marshaller.fromClass(Installation.class);
        this.registerConverters(marshaller);
        InstallationXMLPersistStrategy.registerOmitedFields(marshaller);
        marshaller.toXML((Object)toMarshal, (Writer)new ValidateTagWriter(writer));
    }

    @Override
    public Installation unmarshal(Reader reader) {
        Serialization unmarshaller = SerializationFacade.createUnmarshaller();
        unmarshaller.fromClass(Installation.class);
        this.registerConverters(unmarshaller);
        this.registerBackwardsCompatibility(unmarshaller);
        InstallationXMLPersistStrategy.registerOmitedFields(unmarshaller);
        Installation result = (Installation)unmarshaller.fromXML(reader);
        return result;
    }

    private void registerConverters(Serialization serializer) {
        serializer.alias("WorldTransform", WorldTransform.class);
        serializer.alias("BaseView", BaseView.class);
        serializer.alias("ToolView", ToolView.class);
        serializer.alias("GeomPoseNode", GeomPoseNode.class);
        serializer.alias("GeomLineNode", GeomLineNode.class);
        serializer.alias("GeomPlaneNode", GeomPlaneNode.class);
        serializer.alias("CameraView", CameraView.class);
        serializer.alias("Installation", Installation.class);
        serializer.registerConversionStrategy((ConversionStrategy)new CompositeConversionStrategy<Installation>(Installation.class){
            {
                this.add((ConversionStrategy)InstallationXMLPersistStrategy.this.builder.get(RobotInstallationUpgraderV1.class));
                this.add((ConversionStrategy)InstallationXMLPersistStrategy.this.builder.get(RobotInstallationConverterStrategy_v3_1.class));
                this.add((ConversionStrategy)InstallationXMLPersistStrategy.this.builder.get(RobotInstallationConverterStrategy_v3_0.class));
            }
        });
        serializer.registerConversionStrategy((ConversionStrategy)this.builder.get(VersionConversionStrategy.class));
        serializer.registerConversionStrategy((ConversionStrategy)new CompositeConversionStrategy<InstallationComponent>(InstallationComponent.class){
            {
                for (InstallationComponentConversionStrategy each : InstallationXMLPersistStrategy.this.installationComponentConversionStrategySet) {
                    this.add((ConversionStrategy)each);
                }
            }
        });
        serializer.registerConversionStrategy((ConversionStrategy)this.builder.get(CameraViewConversionStrategy.class));
        serializer.registerConversionStrategy((ConversionStrategy)this.builder.get(WorldTransformConversionStrategy.class));
        serializer.registerConversionStrategy((ConversionStrategy)this.builder.get(BaseViewConversionStrategy.class));
        serializer.registerConversionStrategy((ConversionStrategy)this.builder.get(ToolViewConversionStrategy.class));
        serializer.registerConversionStrategy((ConversionStrategy)this.builder.get(GeomPoseNodeConversionStrategy.class));
        serializer.registerConversionStrategy((ConversionStrategy)this.builder.get(GeomLineNodeConversionStrategy.class));
        serializer.registerConversionStrategy((ConversionStrategy)this.builder.get(GeomPlaneNodeConversionStrategy.class));
        serializer.registerConversionStrategy((ConversionStrategy)this.builder.get(ModbusUnitConversionStrategy.class));
        serializer.registerConversionStrategy((ConversionStrategy)this.builder.get(ModbusSignalConversionStrategy.class));
    }

    private void registerBackwardsCompatibility(Serialization serializer) {
        serializer.alias("gui.main.RobotEnvironment", Installation.class);
        serializer.alias("gui.main.RobotInstallation", Installation.class);
        serializer.alias("gui.installation.RobotInstallation", Installation.class);
    }

    private static void registerOmitedFields(Serialization serializer) {
        serializer.omitField(GeomFeature.class, "objectCreatedInGuiVersion");
        serializer.omitField(GeomFeature.class, "isRequestingANewName");
        serializer.omitField(ModbusSignal.class, "isRequestingANewName");
        serializer.omitField(ModbusSignal.class, "installationName");
        serializer.omitField(Variable.class, "requestANewUniqueName");
    }

    private class ValidateTagWriter
    extends Writer {
        private final Writer writer;

        public ValidateTagWriter(Writer writer) {
            this.writer = writer;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            String unchecked = new String(cbuf);
            String[] stringArray = unchecked.split("\\s+");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String each = stringArray[n2];
                if (each.startsWith("<") && each.contains(".")) {
                    Log.warning((String)("Unable to support classpath name structures: " + each));
                }
                ++n2;
            }
            this.writer.write(cbuf, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.writer.flush();
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }
}

