/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.polyscope.persistence.installation;

import com.ur.lang.EqualsUtil;
import com.ur.lang.PrimitiveUtils;
import com.ur.monitor.model.Pose6d;
import com.ur.move.speedslider.SpeedSliderComponent;
import com.ur.polyscope.immi.Immi;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationComponent;
import com.ur.polyscope.installation.MetaData;
import com.ur.polyscope.installation.PersistanceMetaData;
import com.ur.polyscope.installation.VersionMetaData;
import com.ur.polyscope.internaltcp.domain.TCPSettings;
import com.ur.polyscope.io.tool.ToolIOSettings;
import com.ur.polyscope.io.tool.ToolMode;
import com.ur.polyscope.io.tool.Voltage;
import com.ur.polyscope.payload.PayloadService;
import com.ur.polyscope.payload.common.InstallationPayloadComponent;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.Options;
import com.ur.polyscope.persistence.OptionsSection;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.persistence.Persistable;
import com.ur.polyscope.pin.AbstractPin;
import com.ur.polyscope.pin.OutputActionPin;
import com.ur.polyscope.pin.actions.OutputPinAction;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.robot.configuration.RobotConfigurationProvider;
import com.ur.polyscope.robot.configuration.controller.ConfigurationState;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import com.ur.polyscope.valueobjects.Weight;
import com.ur.polyscope.version.urversion.URVersion;
import com.ur.polyscope.viewfacade.installation.InstallationComponentProvider;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.swing.ViewContext;
import com.ur.view.modbus.ModbusComponent;
import com.ur.view.modbus.ModbusUnit;
import com.ur.view.polyscope.persistence.installation.geom.GeomLineNodeConversionStrategy;
import com.ur.view.polyscope.persistence.installation.geom.GeomPlaneNodeConversionStrategy;
import com.ur.view.polyscope.persistence.installation.geom.GeomPoseNodeConversionStrategy;
import com.ur.view.polyscope.persistence.installation.motionsettings.MotionSettingsConfiguration;
import com.ur.view.polyscope.persistence.installation.smoothtransition.SmoothTransitionSettings;
import com.ur.view.polyscope.persistence.installation.toolwrench.ToolWrenchConfiguration;
import gui.geom.BaseView;
import gui.geom.CameraView;
import gui.geom.GeomFeatureFactory;
import gui.geom.WorldTransform;
import gui.installation.services.RobotInstallationCreator;
import gui.polyscope.setup.treenodes.geom.SetupFeatureContainerNode;
import java.util.Arrays;
import java.util.Set;
import javax.inject.Inject;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;

public class RobotInstallationConverterStrategy_v3_0
extends ConversionStrategyTemplate<Installation> {
    public static final String DIRECTORY_KEY = "directory";
    public static final String FILENAME_KEY = "filename";
    public static final String PERSISTENCE_KEY = "persistence";
    private static final String INSTALLATION_V3_0_IDENTIFICATION = "gui.installation.RobotInstallation";
    private static final String[] IGNORE_LIST = new String[]{"outputSignalOptions", "variableChangedListeners", "alternativeInstallationVariablesDirectory", "laserDistanceSensorEnabled", "euromap67InterfaceEnabled", "teachPendantSafetyEnabled", "cameraAngle", "cameraHeight", "cameraDistance", "autoInitializeJointDirection", "autoInitializeJointOrder", "speedSlider", "collisionCheck", "worldTransform"};
    private static final String TOOL_OUTPUT_VOLTAGE = "toolOutputVoltage";
    final BaseView baseFeature;
    final GeomFeatureFactory geomEntityFactory;
    final GeomPoseNodeConversionStrategy poseNodeConversionStrategy;
    final GeomLineNodeConversionStrategy lineNodeConversionStrategy;
    final GeomPlaneNodeConversionStrategy planeNodeConversionStrategy;
    final ViewContext viewContext;
    private final RobotInstallationCreator factory;
    private final IOService ioService;
    private final Set<InstallationComponentProvider> installationComponentProviders;
    private double jointZeroOffsetAngle = 0.0;
    private double mountingTiltAngle = 0.0;
    private Options persistedData;
    private RobotConfigurationProvider robotConfigurationProvider;
    private ConfigurationState configurationState;
    private final PayloadService payloadService;
    private boolean[] immiPreserveStateAtProgramStop;
    private boolean[] immiIfNotPreserveStateThenSetToLowAtProgramStop;
    boolean[] outputPreserveStateAtProgramStop;
    boolean[] lowIfNotPreserveAtProgramStop;
    CameraView cameraView = null;
    boolean cameraViewSet = false;

    @Inject
    public RobotInstallationConverterStrategy_v3_0(BaseView baseFeature, RobotInstallationCreator factory, IOService ioService, GeomFeatureFactory entityFactory, Set<InstallationComponentProvider> safetySetupProvider, GeomPoseNodeConversionStrategy poseNodeConversionStrategy, GeomLineNodeConversionStrategy lineNodeConversionStrategy, GeomPlaneNodeConversionStrategy planeNodeConversionStrategy, ViewContext viewContext, RobotConfigurationProvider robotConfigurationProvider, ConfigurationState configurationState, PayloadService payloadService) {
        super(Installation.class);
        this.baseFeature = baseFeature;
        this.factory = factory;
        this.ioService = ioService;
        this.geomEntityFactory = entityFactory;
        this.installationComponentProviders = safetySetupProvider;
        this.poseNodeConversionStrategy = poseNodeConversionStrategy;
        this.lineNodeConversionStrategy = lineNodeConversionStrategy;
        this.planeNodeConversionStrategy = planeNodeConversionStrategy;
        this.viewContext = viewContext;
        this.robotConfigurationProvider = robotConfigurationProvider;
        this.configurationState = configurationState;
        this.payloadService = payloadService;
    }

    public boolean canUnmarshalFrom(PersistReader reader) {
        return this.isInstallationFromVersion3_0(reader.getNodeName());
    }

    private boolean isInstallationFromVersion3_0(String installationID) {
        return INSTALLATION_V3_0_IDENTIFICATION.equals(installationID);
    }

    public void marshal(Installation installation, PersistWriter writer) {
    }

    public Installation unmarshal(PersistReader reader) {
        Installation result = this.factory.createRobotInstallation();
        result.setMetaData((MetaData)new VersionMetaData(URVersion.POLYSCOPE_VERSION_PRE_3_0, URVersion.NULL_VERSION));
        result.setComponent((InstallationComponent)SmoothTransitionSettings.defaultForOldInstallations());
        result.setComponent((InstallationComponent)new MotionSettingsConfiguration(this.robotConfigurationProvider.getRobotID()));
        result.setComponent((InstallationComponent)new ToolWrenchConfiguration());
        this.persistedData = new Options();
        while (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            this.pre3_1(result, reader);
            reader.moveToParentNode();
        }
        this.handleLegacyOutputActions();
        for (InstallationComponentProvider each : this.installationComponentProviders) {
            InstallationComponent installationComponent = each.get();
            if (installationComponent instanceof Persistable) {
                ((Persistable)installationComponent).readFrom(this.persistedData);
            }
            result.setComponent(installationComponent);
        }
        if (!((SetupFeatureContainerNode)result.getComponent(SetupFeatureContainerNode.class)).hasWorldTransform()) {
            WorldTransform worldTransform = new WorldTransform(this.jointZeroOffsetAngle, this.mountingTiltAngle);
            ((SetupFeatureContainerNode)result.getComponent(SetupFeatureContainerNode.class)).setWorldFeatures(new CameraView(worldTransform, this.robotConfigurationProvider, this.configurationState), worldTransform);
        }
        OptionsSection ports = this.persistedData.getSection("IOPorts");
        String[] configurableInputs = new String[8];
        String[] configurableOutputs = new String[8];
        OptionsSection persistence = this.persistedData.getSection(PERSISTENCE_KEY);
        result.setMetaData((MetaData)new PersistanceMetaData(persistence.getString(DIRECTORY_KEY), persistence.getString(FILENAME_KEY)));
        for (Pin each : this.ioService.getAllOutputs()) {
            if (!(each instanceof OutputActionPin)) continue;
            OutputActionPin pin = (OutputActionPin)each;
            try {
                if (pin.getOutputAction() != OutputPinAction.CONTINUOUS_PULSE) continue;
                pin.setOutputAction(OutputPinAction.NONE);
            }
            catch (Exception exception) {}
        }
        this.setUserDefinedNames(this.ioService.getConfigurableDigitalInputPins(), ports.getStringArray("safetyInputs", configurableInputs), 0);
        this.setUserDefinedNames(this.ioService.getConfigurableDigitalOutputPins(), ports.getStringArray("safetyOutputs", configurableOutputs), 0);
        return result;
    }

    private void handleLegacyFormat(Installation installation) {
        if (this.immiPreserveStateAtProgramStop != null && this.immiIfNotPreserveStateThenSetToLowAtProgramStop != null) {
            int i = 0;
            while (i < this.immiPreserveStateAtProgramStop.length) {
                OutputPinAction outputPinAction = OutputPinAction.byValues((boolean)false, (boolean)this.immiIfNotPreserveStateThenSetToLowAtProgramStop[i], (boolean)this.immiPreserveStateAtProgramStop[i]);
                ((Immi)installation.getComponent(Immi.class)).setImmiOutputPinAction(i, outputPinAction);
                ++i;
            }
            this.immiPreserveStateAtProgramStop = null;
            this.immiIfNotPreserveStateThenSetToLowAtProgramStop = null;
        }
    }

    private void pre3_1(Installation result, PersistReader reader) {
        if (EqualsUtil.equalsOneOf((Object)reader.getNodeName(), (Object[])IGNORE_LIST)) {
            return;
        }
        OptionsSection persistence = this.persistedData.getSection(PERSISTENCE_KEY);
        OptionsSection defaultProgram = this.persistedData.getSection("defaultProgram");
        if (reader.isNode("cameraView")) {
            this.cameraView = (CameraView)((Object)reader.convertContainedValue((Object)result, CameraView.class));
            if (!this.cameraViewSet) {
                ((SetupFeatureContainerNode)result.getComponent(SetupFeatureContainerNode.class)).setWorldFeatures(this.cameraView, this.cameraView.getWorldTransform());
            }
        } else if (reader.isNode("featureContainer")) {
            result.setComponent((InstallationComponent)reader.convertContainedValue((Object)result, SetupFeatureContainerNode.class));
            ((SetupFeatureContainerNode)result.getComponent(SetupFeatureContainerNode.class)).setWorldFeatures(this.cameraView, this.cameraView.getWorldTransform());
            this.cameraViewSet = true;
        } else if (reader.isNode(DIRECTORY_KEY)) {
            persistence.setString(DIRECTORY_KEY, reader.getStringValue());
        } else if (reader.isNode(FILENAME_KEY)) {
            persistence.setString(FILENAME_KEY, reader.getStringValue());
        } else if (reader.isNode("tcpTransform")) {
            ((TCPSettings)result.getComponent(TCPSettings.class)).addNewTCP(new Pose6d(reader.getDoubleArrayValue()));
        } else if (reader.isNode("showSpeedSliderOnRunscreenEnabled")) {
            result.setComponent((InstallationComponent)new SpeedSliderComponent(reader.getBooleanValue()));
        } else if (reader.isNode("toolPayload")) {
            InstallationPayloadComponent payloadComponent = this.payloadService.addPayloadWithoutDelay("Payload", Weight.from((double)reader.getDoubleValue(), (Weight.Unit)Weight.Unit.SI), new Vector3d(), new Matrix3d());
            this.payloadService.setInstallationDefaultPayload(payloadComponent);
        } else if (reader.isNode("outputPreserveStateAtProgramStop")) {
            this.outputPreserveStateAtProgramStop = reader.getBooleanArrayValue();
        } else if (reader.isNode("lowIfNotPreserveAtProgramStop")) {
            this.lowIfNotPreserveAtProgramStop = reader.getBooleanArrayValue();
        } else if (reader.isNode("modbusInterface")) {
            ((ModbusComponent)result.getComponent(ModbusComponent.class)).getModbusInterface().clear();
            while (reader.hasMoreNodes()) {
                reader.moveToChildNode();
                if (reader.hasMoreNodes()) {
                    ((ModbusComponent)result.getComponent(ModbusComponent.class)).getModbusInterface().addUnit((ModbusUnit)reader.convertContainedValue(ModbusUnit.class));
                }
                reader.moveToParentNode();
            }
        } else if (reader.isNode("analogInputRange")) {
            ((IOService)result.getComponent(IOService.class)).setAnalogInputRange(reader.getIntegerArrayValue());
        } else if (reader.isNode("analogOutputDomain")) {
            ((IOService)result.getComponent(IOService.class)).setAnalogOutputDomain(reader.getIntegerArrayValue());
        } else if (reader.isNode("version")) {
            result.setMetaData((MetaData)new VersionMetaData((URVersion)reader.convertContainedValue((Object)result, URVersion.class), URVersion.NULL_VERSION));
        } else if (reader.isNode("jointZeroOffsetAngle")) {
            this.jointZeroOffsetAngle = reader.getDoubleValue();
        } else if (reader.isNode("mountingTiltAngle")) {
            this.mountingTiltAngle = reader.getDoubleValue();
        } else if (reader.isNode(TOOL_OUTPUT_VOLTAGE)) {
            ToolIOSettings toolIOSettings = (ToolIOSettings)result.getComponent(ToolIOSettings.class);
            ToolMode currentToolMode = toolIOSettings.getToolMode();
            toolIOSettings.setToolMode(new ToolMode(currentToolMode.getOutputMode(), currentToolMode.getPin0Mode(), currentToolMode.getPin1Mode()));
            toolIOSettings.setToolVoltage(Voltage.enumValueOf((int)reader.getIntegerValue()));
        } else if (reader.isNode("euromapOutputModificationChoice")) {
            ((Immi)result.getComponent(Immi.class)).setImmiOutputModificationChoice(reader.getIntegerArrayValue());
        } else if (reader.isNode("euromapPreserveStateAtProgramStop")) {
            if (this.immiPreserveStateAtProgramStop == null) {
                this.immiPreserveStateAtProgramStop = reader.getBooleanArrayValueAttribute();
                this.handleLegacyFormat(result);
            }
        } else if (reader.isNode("euromapIfNotPreserveStateThenSetToLowAtProgramStop")) {
            if (this.immiIfNotPreserveStateThenSetToLowAtProgramStop == null) {
                this.immiIfNotPreserveStateThenSetToLowAtProgramStop = reader.getBooleanArrayValueAttribute();
                this.handleLegacyFormat(result);
            }
        } else if (reader.isNode("inputNames")) {
            String[] inputNames = reader.getStringArrayValue();
            this.setUserDefinedNames(this.ioService.getStandardDigitalInputPins(), inputNames, 0);
            this.setUserDefinedNames(this.ioService.getToolDigitalInputPins(), inputNames, 8);
            this.setUserDefinedNames(this.ioService.getStandardAnalogInputPins(), inputNames, 10);
            this.setUserDefinedNames(this.ioService.getToolAnalogInputPins(), inputNames, 12);
        } else if (reader.isNode("outputNames")) {
            String[] outputNames = reader.getStringArrayValue();
            this.setUserDefinedNames(this.ioService.getStandardDigitalOutputPins(), outputNames, 0);
            this.setUserDefinedNames(this.ioService.getToolDigitalOutputPins(), outputNames, 8);
            this.setUserDefinedNames(this.ioService.getStandardAnalogOutputPins(), outputNames, 10);
        } else if (reader.isNode("kinematics")) {
            reader.convertContainedValue(KinematicsCalibration.class);
        } else if (reader.isNode("defaultProgramFile")) {
            defaultProgram.setString("defaultProgramFile", reader.getStringValue());
        } else if (reader.isNode("automaitcallyLoadDefaultProgram")) {
            defaultProgram.setBoolean("automaitcallyLoadDefaultProgram", Boolean.valueOf(reader.getBooleanValue()));
        } else if (reader.isNode("automaitcallyStartDefaultProgram")) {
            defaultProgram.setBoolean("automaitcallyStartDefaultProgram", Boolean.valueOf(reader.getBooleanValue()));
        } else if (reader.isNode("automaitcallyInitializeRobot")) {
            defaultProgram.setBoolean("automaitcallyInitializeRobot", Boolean.valueOf(reader.getBooleanValue()));
        } else if (reader.isNode("autoStartDefaultProgramSensor")) {
            defaultProgram.setInteger("autoStartDefaultProgramSensor", Integer.valueOf(reader.getIntegerValue()));
        } else if (reader.isNode("autoStartProgramSensorValue")) {
            defaultProgram.setBoolean("autoStartProgramSensorValue", Boolean.valueOf(reader.getBooleanValue()));
        } else if (reader.isNode("autoInitializeSensor")) {
            defaultProgram.setInteger("autoInitializeSensor", Integer.valueOf(reader.getIntegerValue()));
        } else if (reader.isNode("autoInitializeSensorValue")) {
            defaultProgram.setBoolean("autoInitializeSensorValue", Boolean.valueOf(reader.getBooleanValue()));
        } else if (reader.isNode("persistedData")) {
            this.persistedData = reader.getOptionsValue();
            this.persistedData.setSection("defaultProgram", defaultProgram);
        } else {
            InstallationComponent component = (InstallationComponent)reader.convertContainedValue(InstallationComponent.class);
            if (component == null) {
                throw new IllegalArgumentException("Loaded component is null");
            }
            result.setComponent(component);
        }
        this.persistedData.setSection(PERSISTENCE_KEY, persistence);
    }

    private void ensureCorrectArrayLength() {
        if (this.outputPreserveStateAtProgramStop.length < 20) {
            int length = this.outputPreserveStateAtProgramStop.length;
            this.outputPreserveStateAtProgramStop = Arrays.copyOf(this.outputPreserveStateAtProgramStop, 20);
            int i = length;
            while (i < 20) {
                this.outputPreserveStateAtProgramStop[i] = true;
                ++i;
            }
        }
        if (this.lowIfNotPreserveAtProgramStop == null) {
            this.lowIfNotPreserveAtProgramStop = PrimitiveUtils.initArray((boolean)false, (int)20);
        }
    }

    private void handleLegacyOutputActions() {
        if (this.outputPreserveStateAtProgramStop != null) {
            this.ensureCorrectArrayLength();
            this.setPinActionsBasedOnBooleanArrays();
            this.outputPreserveStateAtProgramStop = null;
            this.lowIfNotPreserveAtProgramStop = null;
        }
    }

    private void setPinActionsBasedOnBooleanArrays() {
        Pin[] standardDI = this.ioService.getStandardDigitalOutputPins();
        Pin[] tool = this.ioService.getToolDigitalOutputPins();
        Pin[] standardAnalog = this.ioService.getStandardAnalogOutputPins();
        Pin[] configurable = this.ioService.getConfigurableDigitalOutputPins();
        int pinOffset = 0;
        int i = 0;
        while (i < standardDI.length) {
            ((AbstractPin)standardDI[i]).setOutputAction(OutputPinAction.byValues((boolean)false, (boolean)this.outputPreserveStateAtProgramStop[pinOffset + i], (boolean)this.lowIfNotPreserveAtProgramStop[pinOffset + i]));
            ++i;
        }
        pinOffset += standardDI.length;
        i = 0;
        while (i < tool.length) {
            ((AbstractPin)tool[i]).setOutputAction(OutputPinAction.byValues((boolean)false, (boolean)this.outputPreserveStateAtProgramStop[pinOffset + i], (boolean)this.lowIfNotPreserveAtProgramStop[pinOffset + i]));
            ++i;
        }
        pinOffset += tool.length;
        i = 0;
        while (i < standardAnalog.length) {
            ((AbstractPin)standardAnalog[i]).setOutputAction(OutputPinAction.byValues((boolean)false, (boolean)this.outputPreserveStateAtProgramStop[pinOffset + i], (boolean)this.lowIfNotPreserveAtProgramStop[pinOffset + i]));
            ++i;
        }
        if (this.outputPreserveStateAtProgramStop.length > (pinOffset += standardAnalog.length)) {
            i = 0;
            while (i < configurable.length) {
                ((AbstractPin)configurable[i]).setOutputAction(OutputPinAction.byValues((boolean)false, (boolean)this.outputPreserveStateAtProgramStop[pinOffset + i], (boolean)this.lowIfNotPreserveAtProgramStop[pinOffset + i]));
                ++i;
            }
        }
    }

    private void setUserDefinedNames(Pin<?>[] pins, String[] names, int offset) {
        int i = 0;
        while (i < pins.length) {
            pins[i].setName(names[i + offset]);
            ++i;
        }
    }
}

