/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.polyscope.persistence.installation;

import com.google.common.collect.Sets;
import com.ur.lang.EqualsUtil;
import com.ur.lang.PrimitiveUtils;
import com.ur.move.speedslider.SpeedSliderComponent;
import com.ur.polyscope.installation.IgnorePersistence;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationComponent;
import com.ur.polyscope.installation.MetaData;
import com.ur.polyscope.installation.PersistanceMetaData;
import com.ur.polyscope.installation.VersionMetaData;
import com.ur.polyscope.io.tool.ToolIOSettings;
import com.ur.polyscope.io.tool.ToolMode;
import com.ur.polyscope.io.tool.Voltage;
import com.ur.polyscope.persistence.ConversionStrategy;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.pin.AbstractPin;
import com.ur.polyscope.pin.ModifiablePin;
import com.ur.polyscope.pin.PersistIOPart;
import com.ur.polyscope.pin.actions.InputPinActionLookupService;
import com.ur.polyscope.pin.actions.OutputPinAction;
import com.ur.polyscope.pin.internal.IOServiceConversionStrategy;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.robot.configuration.RobotConfigurationProvider;
import com.ur.polyscope.version.urversion.URVersion;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.swing.ViewContext;
import com.ur.util.CollectionUtils;
import com.ur.view.polyscope.module.installation.InstallationContributionsProvider;
import com.ur.view.polyscope.persistence.installation.geom.GeomLineNodeConversionStrategy;
import com.ur.view.polyscope.persistence.installation.geom.GeomPlaneNodeConversionStrategy;
import com.ur.view.polyscope.persistence.installation.geom.GeomPoseNodeConversionStrategy;
import com.ur.view.polyscope.persistence.installation.motionsettings.MotionSettingsConfiguration;
import com.ur.view.polyscope.persistence.installation.smoothtransition.SmoothTransitionSettings;
import com.ur.view.polyscope.persistence.installation.toolwrench.ToolWrenchConfiguration;
import gui.geom.BaseView;
import gui.geom.GeomFeatureFactory;
import gui.installation.services.RobotInstallationCreator;
import java.util.Arrays;
import java.util.Set;
import javax.inject.Inject;

public class RobotInstallationConverterStrategy_v3_1
extends ConversionStrategyTemplate<Installation> {
    static final Set<String> TO_IGNORE = Sets.newHashSet((Object[])new String[]{"com.ur.view.installation.speedslider.SpeedSliderComponent"});
    static final String INSTALLATION = "Installation";
    private static final String DIRECTORY = "directory";
    private static final String FILE_NAME = "fileName";
    private static final String SHOW_SPEED_SLIDER_ON_RUN_TAB = "showSpeedSliderOnRunTab";
    private static final String TOOL_OUTPUT_VOLTAGE = "toolOutputVoltage";
    private static final String PRESERVE_SIGNAL_AT_PROGRAM_STOP = "preserveSignalAtProgramStop";
    private static final String SET_SIGNAL_LOW = "setSignalLow";
    private static final String PROGRAM_STATE_MODE = "ProgramStateMode";
    private static final String I_OS = "IOs";
    private static final String VERSION = "Version";
    private static final String LAST_SAVED_IN_VERSION = "LastSavedInVersion";
    protected final GeomPoseNodeConversionStrategy poseNodeConversionStrategy;
    protected final GeomLineNodeConversionStrategy lineNodeConversionStrategy;
    protected final GeomPlaneNodeConversionStrategy planeNodeConversionStrategy;
    protected final ViewContext viewContext;
    final GeomFeatureFactory geomEntityFactory;
    final BaseView baseFeature;
    private final RobotInstallationCreator factory;
    private final InstallationContributionsProvider contributionsProvider;
    private final Set<PersistIOPart> ioConversionParts;
    private final InputPinActionLookupService inputPinActionLookupService;
    private final RobotConfigurationProvider robotConfigurationProvider;
    private boolean hasContinuousPulseTag = false;
    private IOService ioService;

    @Inject
    public RobotInstallationConverterStrategy_v3_1(Set<PersistIOPart> ioConversionParts, BaseView baseFeature, RobotInstallationCreator factory, IOService ioService, GeomFeatureFactory entityFactory, InstallationContributionsProvider contributionsProvider, GeomPoseNodeConversionStrategy poseNodeConversionStrategy, GeomLineNodeConversionStrategy lineNodeConversionStrategy, GeomPlaneNodeConversionStrategy planeNodeConversionStrategy, ViewContext viewContext, InputPinActionLookupService inputPinActionLookupService, RobotConfigurationProvider robotConfigurationProvider) {
        super(Installation.class);
        this.ioConversionParts = ioConversionParts;
        this.baseFeature = baseFeature;
        this.factory = factory;
        this.ioService = ioService;
        this.geomEntityFactory = entityFactory;
        this.contributionsProvider = contributionsProvider;
        this.poseNodeConversionStrategy = poseNodeConversionStrategy;
        this.lineNodeConversionStrategy = lineNodeConversionStrategy;
        this.planeNodeConversionStrategy = planeNodeConversionStrategy;
        this.viewContext = viewContext;
        this.inputPinActionLookupService = inputPinActionLookupService;
        this.robotConfigurationProvider = robotConfigurationProvider;
    }

    public boolean canUnmarshalFrom(PersistReader reader) {
        return this.isInstallationFromVersion3_1(reader);
    }

    private boolean isInstallationFromVersion3_1(PersistReader reader) {
        return this.isInstallation(reader) && this.doesNotHaveInstallationVersion(reader);
    }

    private boolean isInstallation(PersistReader persistReader) {
        return EqualsUtil.equals((Object)persistReader.getNodeName(), (Object)INSTALLATION);
    }

    private boolean doesNotHaveInstallationVersion(PersistReader persistReader) {
        return !persistReader.hasOneOfAttributes(new String[]{"INSTALLATION-VERSION", "INSTALLATION-LAST-SAVED-VERSION"});
    }

    public void marshal(Installation installation, PersistWriter writer) {
        this.marshalInitialInstallation(installation, writer);
        VersionMetaData versionMetaData = (VersionMetaData)installation.getMetaData(VersionMetaData.class);
        writer.startNode(VERSION);
        writer.writeContainedValue((Object)versionMetaData.getCreatedInVersion());
        writer.endNode();
        writer.startNode(LAST_SAVED_IN_VERSION);
        writer.writeContainedValue((Object)versionMetaData.getLastSavedInVersion());
        writer.endNode();
        for (InstallationComponent each : installation.getAllComponents()) {
            if (each instanceof IgnorePersistence) continue;
            writer.writeNodeWithValue((Object)each);
        }
        writer.startNode("Contributions");
        this.contributionsProvider.marshal(writer);
        writer.endNode();
    }

    public void marshalInitialInstallation(Installation installation, PersistWriter writer) {
        PersistanceMetaData persistanceMetaData = (PersistanceMetaData)installation.getMetaData(PersistanceMetaData.class);
        writer.addAttribute(DIRECTORY, persistanceMetaData.directory());
        writer.addAttribute(FILE_NAME, persistanceMetaData.fileName());
        writer.addAttribute(SHOW_SPEED_SLIDER_ON_RUN_TAB, ((SpeedSliderComponent)installation.getComponent(SpeedSliderComponent.class)).isShowSpeedSlider());
        writer.startNode(I_OS);
        writer.writeContainedValue((Object)this.ioService, (ConversionStrategy)new IOServiceConversionStrategy(this.ioConversionParts, installation, this.ioService, this.inputPinActionLookupService));
        writer.endNode();
    }

    public Installation unmarshal(PersistReader reader) {
        Installation result = this.factory.createRobotInstallationIgnoreContributions();
        result.setMetaData((MetaData)new VersionMetaData(URVersion.POLYSCOPE_VERSION_PRE_3_0, URVersion.NULL_VERSION));
        result.setMetaData((MetaData)new PersistanceMetaData(reader.getStringAttribute(DIRECTORY), reader.getStringAttribute(FILE_NAME)));
        result.setComponent((InstallationComponent)new SpeedSliderComponent(reader.getBooleanAttribute(SHOW_SPEED_SLIDER_ON_RUN_TAB)));
        boolean hasToolOutputVoltage = reader.hasOneOfAttributes(new String[]{TOOL_OUTPUT_VOLTAGE});
        int toolOutputVoltage = hasToolOutputVoltage ? reader.getIntegerAttribute(TOOL_OUTPUT_VOLTAGE) : 0;
        result.setComponent((InstallationComponent)SmoothTransitionSettings.defaultForOldInstallations());
        result.setComponent((InstallationComponent)new MotionSettingsConfiguration(this.robotConfigurationProvider.getRobotID()));
        result.setComponent((InstallationComponent)new ToolWrenchConfiguration());
        this.unmarshalInstallation(reader, result);
        ToolIOSettings toolIOSettings = (ToolIOSettings)result.getComponent(ToolIOSettings.class);
        if (hasToolOutputVoltage) {
            ToolMode currentToolMode = toolIOSettings.getToolMode();
            toolIOSettings.setToolMode(new ToolMode(currentToolMode.getOutputMode(), currentToolMode.getPin0Mode(), currentToolMode.getPin1Mode()));
            Voltage voltage = Voltage.enumValueOf((int)toolOutputVoltage);
            toolIOSettings.setToolVoltage(voltage);
        }
        return result;
    }

    private void unmarshalInstallation(PersistReader reader, Installation result) {
        boolean unmarshalledContributions = false;
        URVersion version = URVersion.POLYSCOPE_VERSION_PRE_3_0;
        URVersion lastSavedVersion = URVersion.NULL_VERSION;
        boolean[] programStateMode = null;
        boolean[] outputPreserveStateAtProgramStop = null;
        boolean[] lowIfNotPreserveAtProgramStop = null;
        while (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            if (reader.isNode(PRESERVE_SIGNAL_AT_PROGRAM_STOP)) {
                outputPreserveStateAtProgramStop = this.handleOutputActions(reader, true);
            } else if (reader.isNode(SET_SIGNAL_LOW)) {
                lowIfNotPreserveAtProgramStop = this.handleOutputActions(reader, false);
            } else if (reader.isNode(PROGRAM_STATE_MODE)) {
                programStateMode = this.handleProgramStateNode(reader);
            } else if (reader.isNode(I_OS)) {
                reader.convertContainedValue((Object)this.ioService, IOService.class, (ConversionStrategy)new IOServiceConversionStrategy(this.ioConversionParts, result, this.ioService, this.inputPinActionLookupService));
            } else if (reader.isNode(VERSION)) {
                version = (URVersion)reader.convertContainedValue((Object)result, URVersion.class);
            } else if (reader.isNode(LAST_SAVED_IN_VERSION)) {
                lastSavedVersion = (URVersion)reader.convertContainedValue((Object)result, URVersion.class);
            } else if (reader.isNode("Contributions")) {
                this.contributionsProvider.unmarshal(reader);
                unmarshalledContributions = true;
            } else if (!TO_IGNORE.contains(reader.getNodeName())) {
                this.handleUnknownNode(reader, result);
            }
            reader.moveToParentNode();
        }
        result.setMetaData((MetaData)new VersionMetaData(version, lastSavedVersion));
        if (!unmarshalledContributions) {
            this.contributionsProvider.clearData();
        }
        this.handleLegacyOutputActions(outputPreserveStateAtProgramStop, lowIfNotPreserveAtProgramStop, programStateMode);
        if (!this.hasContinuousPulseTag) {
            this.fixPulsing();
        }
    }

    private boolean[] handleProgramStateNode(PersistReader reader) {
        boolean[] programStateMode = PrimitiveUtils.initArray((boolean)false, (int)20);
        boolean[] values = reader.getBooleanArrayValueAttribute();
        programStateMode = values.length < programStateMode.length ? Arrays.copyOf(values, programStateMode.length) : values;
        return programStateMode;
    }

    private void handleUnknownNode(PersistReader reader, Installation result) {
        InstallationComponent component;
        if (reader.isNode("ContinuousPulse")) {
            this.hasContinuousPulseTag = true;
        }
        if ((component = (InstallationComponent)reader.convertContainedValue(InstallationComponent.class)) == null) {
            throw new IllegalArgumentException("Loaded component is null");
        }
        if (!(component instanceof SpeedSliderComponent)) {
            result.setComponent(component);
        }
    }

    private boolean[] handleOutputActions(PersistReader reader, boolean setting) {
        boolean[] outputActions = PrimitiveUtils.initArray((boolean)setting, (int)20);
        boolean[] values = reader.getBooleanArrayValueAttribute();
        System.arraycopy(values, 0, outputActions, 0, values.length);
        int i = values.length;
        while (i < outputActions.length) {
            outputActions[i] = true;
            ++i;
        }
        return outputActions;
    }

    private void handleLegacyOutputActions(boolean[] outputPreserveStateAtProgramStop, boolean[] lowIfNotPreserveAtProgramStop, boolean[] programStateMode) {
        if (outputPreserveStateAtProgramStop != null && lowIfNotPreserveAtProgramStop != null && programStateMode != null) {
            Pin[] standardDI = this.ioService.getStandardDigitalOutputPins();
            Pin[] tool = this.ioService.getToolDigitalOutputPins();
            Pin[] standardAnalog = this.ioService.getStandardAnalogOutputPins();
            Pin[] configurable = this.ioService.getConfigurableDigitalOutputPins();
            int pinOffset = 0;
            int i = 0;
            while (i < standardDI.length) {
                ((AbstractPin)standardDI[i]).setOutputAction(OutputPinAction.byValues((boolean)programStateMode[pinOffset + i], (boolean)outputPreserveStateAtProgramStop[pinOffset + i], (boolean)lowIfNotPreserveAtProgramStop[pinOffset + i]));
                ++i;
            }
            pinOffset += standardDI.length;
            i = 0;
            while (i < tool.length) {
                ((AbstractPin)tool[i]).setOutputAction(OutputPinAction.byValues((boolean)programStateMode[pinOffset + i], (boolean)outputPreserveStateAtProgramStop[pinOffset + i], (boolean)lowIfNotPreserveAtProgramStop[pinOffset + i]));
                ++i;
            }
            pinOffset += tool.length;
            i = 0;
            while (i < standardAnalog.length) {
                ((AbstractPin)standardAnalog[i]).setOutputAction(OutputPinAction.byValues((boolean)programStateMode[pinOffset + i], (boolean)outputPreserveStateAtProgramStop[pinOffset + i], (boolean)lowIfNotPreserveAtProgramStop[pinOffset + i]));
                ++i;
            }
            pinOffset += standardAnalog.length;
            i = 0;
            while (i < configurable.length) {
                ((AbstractPin)configurable[i]).setOutputAction(OutputPinAction.byValues((boolean)programStateMode[pinOffset + i], (boolean)outputPreserveStateAtProgramStop[pinOffset + i], (boolean)lowIfNotPreserveAtProgramStop[pinOffset + i]));
                ++i;
            }
        }
    }

    private void fixPulsing() {
        for (ModifiablePin each : CollectionUtils.filter((Iterable)this.ioService.getAllOutputs(), ModifiablePin.class)) {
            try {
                if (each.getOutputAction() != OutputPinAction.CONTINUOUS_PULSE) continue;
                each.setOutputAction(OutputPinAction.NONE);
            }
            catch (Exception exception) {}
        }
    }
}

