/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.polyscope.persistence.installation;

import com.ur.injection.Builder;
import com.ur.lang.naming.IgnoreNameChanges;
import com.ur.lang.naming.NameChangeAspect;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationListener;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.installation.MetaData;
import com.ur.polyscope.installation.PersistanceMetaData;
import com.ur.polyscope.installation.VersionMetaData;
import com.ur.polyscope.version.urversion.URVersion;
import com.ur.polyscope.version.urversion.URVersionProvider;
import com.ur.polyscope.viewfacade.safety.RobotInstallationPersistenceService;
import com.ur.util.event.EventManager;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.Subscription;
import com.ur.util.logging.Log;
import com.ur.util.persist.FileUtils;
import com.ur.view.polyscope.persistence.installation.InstallationMetaData;
import com.ur.view.polyscope.persistence.installation.InstallationPersistenceStrategy;
import com.ur.view.polyscope.persistence.installation.InstallationXMLPersistStrategy;
import com.ur.view.polyscope.persistence.installation.PersistDelegator;
import com.ur.view.polyscope.persistence.installation.PreSaveInstallationListener;
import com.ur.view.polyscope.persistence.installation.RobotInstallationPersistence$SerializePersistenceStrategy$AjcClosure1;
import com.ur.view.polyscope.persistence.installation.RobotInstallationPersistence$SerializePersistenceStrategy$AjcClosure3;
import gui.installation.services.LookupServiceFacade;
import gui.tools.LanguagePack;
import gui.tools.LegacyURDialogCreator;
import gui.tools.PersistStrategy;
import gui.tools.URFileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Singleton
public class RobotInstallationPersistence
implements RobotInstallationPersistenceService {
    public static final String INSTALLATION_FILE_TYPE = ".installation";
    private static InstallationPersistenceStrategy persistenceStrategy;
    private static Map<String, Class<?>> ALIAS_FOR_ROBOT_INSTALLATION;

    static {
        ALIAS_FOR_ROBOT_INSTALLATION = new HashMap();
        ALIAS_FOR_ROBOT_INSTALLATION.put("gui.main.RobotEnvironment", Installation.class);
        ALIAS_FOR_ROBOT_INSTALLATION.put("gui.main.RobotInstallation", Installation.class);
        ALIAS_FOR_ROBOT_INSTALLATION = Collections.unmodifiableMap(ALIAS_FOR_ROBOT_INSTALLATION);
    }

    private static InstallationPersistenceStrategy getPersistenceStrategy() {
        if (persistenceStrategy == null) {
            persistenceStrategy = LookupServiceFacade.get(SerializePersistenceStrategy.class);
        }
        return persistenceStrategy;
    }

    public static void setPersistenceStrategy(InstallationPersistenceStrategy persistenceStrategy) {
        RobotInstallationPersistence.persistenceStrategy = persistenceStrategy;
    }

    public static void forTestingClear() {
        persistenceStrategy = null;
    }

    public static Installation load(File file) throws IOException {
        RobotInstallationPersistence.firePreLoadInstallationEvent();
        Installation installation = RobotInstallationPersistence.getPersistenceStrategy().load(file);
        RobotInstallationPersistence.fireInstallationNotification(installation);
        return installation;
    }

    public static Installation loadFromDashboard(File file) throws IOException {
        RobotInstallationPersistence.firePreLoadInstallationEvent();
        Installation installation = RobotInstallationPersistence.getPersistenceStrategy().loadFromDashboard(file);
        RobotInstallationPersistence.fireInstallationNotification(installation);
        return installation;
    }

    private static void fireInstallationNotification(Installation installation) {
        EventNotificationService.notify(InstallationStateListener.class, listener -> {
            if (installation != null) {
                listener.installationLoaded(installation);
            } else {
                listener.installationLoadFailed();
            }
        });
    }

    private static void firePreLoadInstallationEvent() {
        InstallationListener.Event event = new InstallationListener.Event(InstallationListener.EventType.PRE_LOAD_INSTALLATION, null);
        EventNotificationService.notify(InstallationListener.class, installationListener -> installationListener.onInstallationEvent(event));
    }

    public void save(Installation installation) {
        try {
            RobotInstallationPersistence.fireInstallationSavingNotification(installation);
            RobotInstallationPersistence.getPersistenceStrategy().save(installation);
            RobotInstallationPersistence.fireInstallationSavedNotification();
        }
        catch (FileNotFoundException fileNotFoundException) {
            LegacyURDialogCreator.showErrorDialog(LanguagePack.getErrorMessages().unableToSaveInstallationFile(((PersistanceMetaData)installation.getMetaData(PersistanceMetaData.class)).fileName()));
        }
    }

    private static void fireInstallationSavingNotification(Installation installation) {
        EventNotificationService.notify(PreSaveInstallationListener.class, preSaveInstallationListener -> preSaveInstallationListener.saving(installation));
    }

    private static void fireInstallationSavedNotification() {
        EventNotificationService.notify(InstallationStateListener.class, InstallationStateListener::installationSaved);
    }

    public static class SerializePersistenceStrategy
    implements InstallationPersistenceStrategy {
        private final Builder builder;
        private final Set<PersistDelegator> persistDelegators;
        private final URFileUtils.Facade fileUtils;
        private final EventManager eventManager;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

        @Inject
        public SerializePersistenceStrategy(Builder builder) {
            this(builder, new URFileUtils.DefaultFacade());
        }

        SerializePersistenceStrategy(Builder builder, URFileUtils.Facade fileFacade) {
            this.builder = builder;
            this.fileUtils = fileFacade;
            this.eventManager = (EventManager)builder.get(EventManager.class);
            this.persistDelegators = this.getPersistDelegators(builder);
        }

        private Set<PersistDelegator> getPersistDelegators(Builder builder) {
            try {
                return builder.getExtensions(PersistDelegator.class);
            }
            catch (Exception e) {
                Log.warning((String)"No PersistDelegators bound. Robot Installation may not persist everything.", (Throwable)e);
                return Collections.EMPTY_SET;
            }
        }

        private Installation loadFile(File file) throws IOException {
            this.fileUtils.ensureFileExists(file);
            if (FileUtils.getExtension((File)file).equals("installation")) {
                Subscription vetoInstallationEvents = null;
                try {
                    vetoInstallationEvents = this.eventManager.addVeto(InstallationStateListener.class);
                    Log.info((String)("loading installation file: '" + file.getPath() + "'"));
                    Installation robotInstallation = (Installation)this.fileUtils.readPossiblyCompressedFile(file, (PersistStrategy)this.builder.get(InstallationXMLPersistStrategy.class));
                    robotInstallation.setMetaData((MetaData)new PersistanceMetaData(file.getParent(), this.fileUtils.getFileName(file)));
                    for (PersistDelegator each : this.persistDelegators) {
                        each.load(file, robotInstallation);
                    }
                    Installation installation = robotInstallation;
                    return installation;
                }
                catch (InvalidClassException e) {
                    Log.error((String)LanguagePack.getErrorMessages().notARecognizedInstallationFile().getMessage(), (Throwable)e);
                }
                catch (ClassCastException e) {
                    Log.error((String)"Failed to load installation, class cast", (Throwable)e);
                }
                catch (IOException e) {
                    Log.error((String)("File most likely doesn't exist in location [" + file.getAbsolutePath() + "]"), (Throwable)e);
                }
                catch (Exception e) {
                    Log.error((String)"Fatal error on installation load", (Throwable)e);
                }
                finally {
                    if (vetoInstallationEvents != null) {
                        vetoInstallationEvents.dispose();
                    }
                }
            }
            return null;
        }

        @Override
        @IgnoreNameChanges
        public Installation loadFromDashboard(File file) throws IOException {
            File file2 = file;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)file2);
            Object[] objectArray = new Object[]{this, file2, joinPoint};
            RobotInstallationPersistence$SerializePersistenceStrategy$AjcClosure1 robotInstallationPersistence$SerializePersistenceStrategy$AjcClosure1 = new RobotInstallationPersistence$SerializePersistenceStrategy$AjcClosure1(objectArray);
            return (Installation)NameChangeAspect.aspectOf().aroundAnnotatedMethod(robotInstallationPersistence$SerializePersistenceStrategy$AjcClosure1.linkClosureAndJoinPoint(69648));
        }

        @Override
        @IgnoreNameChanges
        public Installation load(File file) throws IOException {
            File file2 = file;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)file2);
            Object[] objectArray = new Object[]{this, file2, joinPoint};
            RobotInstallationPersistence$SerializePersistenceStrategy$AjcClosure3 robotInstallationPersistence$SerializePersistenceStrategy$AjcClosure3 = new RobotInstallationPersistence$SerializePersistenceStrategy$AjcClosure3(objectArray);
            return (Installation)NameChangeAspect.aspectOf().aroundAnnotatedMethod(robotInstallationPersistence$SerializePersistenceStrategy$AjcClosure3.linkClosureAndJoinPoint(69648));
        }

        @Override
        public void save(Installation installation) throws FileNotFoundException {
            PersistanceMetaData persistanceMetaData = (PersistanceMetaData)installation.getMetaData(PersistanceMetaData.class);
            File dir = new File(persistanceMetaData.directory());
            if (!dir.exists()) {
                throw new FileNotFoundException("could not save since directory = \"" + persistanceMetaData.directory() + "\" does not exist");
            }
            Log.info((String)("Saving installation " + persistanceMetaData.fileName()));
            URVersion createdIn = ((VersionMetaData)installation.getMetaData(VersionMetaData.class)).getCreatedInVersion();
            installation.setMetaData((MetaData)new VersionMetaData(createdIn, ((URVersionProvider)this.builder.get(URVersionProvider.class)).getMarketingVersion()));
            installation.setMetaData((MetaData)new InstallationMetaData(2, 2));
            this.saveInstallation(installation);
            for (PersistDelegator each : this.persistDelegators) {
                each.save(installation);
            }
        }

        private void saveInstallation(Installation installation) {
            PersistanceMetaData persistanceMetaData = (PersistanceMetaData)installation.getMetaData(PersistanceMetaData.class);
            String directory = persistanceMetaData.directory();
            String fileName = String.valueOf(persistanceMetaData.fileName()) + RobotInstallationPersistence.INSTALLATION_FILE_TYPE;
            try {
                File file = new File(directory, fileName);
                this.fileUtils.writePossiblyCompressedFile(file, installation, (PersistStrategy)this.builder.get(InstallationXMLPersistStrategy.class));
            }
            catch (IOException e) {
                Log.error((String)"Failed to save", (Throwable)e);
                LegacyURDialogCreator.showErrorDialog(LanguagePack.getErrorMessages().unableToSaveInstallationFile(fileName));
            }
        }

        static {
            SerializePersistenceStrategy.ajc$preClinit();
        }

        static final /* synthetic */ Installation loadFromDashboard_aroundBody0(SerializePersistenceStrategy ajc$this, File file, JoinPoint joinPoint) {
            return ajc$this.loadFile(file);
        }

        static final /* synthetic */ Installation load_aroundBody2(SerializePersistenceStrategy ajc$this, File file, JoinPoint joinPoint) {
            Installation robotInstallation = ajc$this.loadFile(file);
            if (robotInstallation == null) {
                LegacyURDialogCreator.showErrorDialog(LanguagePack.getErrorMessages().notARecognizedInstallationFile());
            }
            return robotInstallation;
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("RobotInstallationPersistence.java", SerializePersistenceStrategy.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "loadFromDashboard", "com.ur.view.polyscope.persistence.installation.RobotInstallationPersistence$SerializePersistenceStrategy", "java.io.File", "file", "java.io.IOException", "com.ur.polyscope.installation.Installation"), 183);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "load", "com.ur.view.polyscope.persistence.installation.RobotInstallationPersistence$SerializePersistenceStrategy", "java.io.File", "file", "java.io.IOException", "com.ur.polyscope.installation.Installation"), 189);
        }
    }
}

