/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.polyscope.persistence.installation;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.MetaData;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.view.polyscope.persistence.installation.InstallationMetaData;
import com.ur.view.polyscope.persistence.installation.RobotInstallationConverterStrategy_v3_1;
import javax.inject.Inject;

public class RobotInstallationUpgraderV1
extends ConversionStrategyTemplate<Installation> {
    private static final String INSTALLATION_IDENTIFICATION = "Installation";
    private static final String CREATED_IN_INSTALLATION_VERSION = "INSTALLATION-VERSION";
    private static final String LAST_SAVED_IN_INSTALLATION_VERSION = "INSTALLATION-LAST-SAVED-VERSION";
    private RobotInstallationConverterStrategy_v3_1 robotInstallationConverterStrategy_v3_1;

    @Inject
    public RobotInstallationUpgraderV1(RobotInstallationConverterStrategy_v3_1 robotInstallationConverterStrategy_v3_1) {
        super(Installation.class);
        this.robotInstallationConverterStrategy_v3_1 = robotInstallationConverterStrategy_v3_1;
    }

    public boolean canUnmarshalFrom(PersistReader reader) {
        return this.installationContainingInstallationVersion(reader);
    }

    private boolean installationContainingInstallationVersion(PersistReader persistReader) {
        return this.isInstallation(persistReader) && this.containsInstallationVersion(persistReader);
    }

    private boolean isInstallation(PersistReader persistReader) {
        return EqualsUtil.equals((Object)persistReader.getNodeName(), (Object)INSTALLATION_IDENTIFICATION);
    }

    private boolean containsInstallationVersion(PersistReader persistReader) {
        return persistReader.hasOneOfAttributes(new String[]{CREATED_IN_INSTALLATION_VERSION, LAST_SAVED_IN_INSTALLATION_VERSION});
    }

    public void marshal(Installation toMarshal, PersistWriter writer) {
        this.addSeparateInstallationVersion(toMarshal, writer);
        this.robotInstallationConverterStrategy_v3_1.marshal(toMarshal, writer);
    }

    private void addSeparateInstallationVersion(Installation installation, PersistWriter persistWriter) {
        InstallationMetaData installationMetaData = this.checkInstallationMetaData(installation);
        persistWriter.addAttribute(CREATED_IN_INSTALLATION_VERSION, installationMetaData.getCreatedInInstallationVersion());
        persistWriter.addAttribute(LAST_SAVED_IN_INSTALLATION_VERSION, installationMetaData.getLastSavedInInstallationVersion());
    }

    private InstallationMetaData checkInstallationMetaData(Installation installation) {
        InstallationMetaData installationMetaData = (InstallationMetaData)installation.getMetaData(InstallationMetaData.class);
        if (installationMetaData == null) {
            installationMetaData = new InstallationMetaData(2, 2);
        }
        return installationMetaData;
    }

    public Installation unmarshal(PersistReader reader) {
        int createdInInstallationVersion = 0;
        int lastSavedInInstallationVersion = 0;
        if (reader.hasOneOfAttributes(new String[]{CREATED_IN_INSTALLATION_VERSION, LAST_SAVED_IN_INSTALLATION_VERSION})) {
            createdInInstallationVersion = reader.getIntegerAttribute(CREATED_IN_INSTALLATION_VERSION);
            lastSavedInInstallationVersion = reader.getIntegerAttribute(LAST_SAVED_IN_INSTALLATION_VERSION);
        }
        Installation installation = this.robotInstallationConverterStrategy_v3_1.unmarshal(reader);
        if (createdInInstallationVersion != 0 && lastSavedInInstallationVersion != 0) {
            installation.setMetaData((MetaData)new InstallationMetaData(createdInInstallationVersion, lastSavedInInstallationVersion));
        }
        return installation;
    }
}

