/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.polyscope.persistence.installation.geom;

import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.polyscope.visualizer.geomfeature.JoggableGeomFeature;
import gui.polyscope.setup.treenodes.geom.GeomPoseNode;
import javax.media.j3d.Transform3D;
import javax.swing.tree.MutableTreeNode;

abstract class BaseGeomConversionStrategy<T>
extends ConversionStrategyTemplate<T> {
    static final String IS_VARIABLE_ATTRIBUTE = "isVariable";
    static final String SHOW_AXES_ATTRIBUTE = "showAxes";
    static final String JOGGABLE_ATTRIBUTE = "joggable";

    BaseGeomConversionStrategy(Class<T> type) {
        super(type);
    }

    void writeGeomFeature(GeomFeature feature, PersistWriter writer) {
        writer.addAttribute(SHOW_AXES_ATTRIBUTE, feature.getShowAxes());
        writer.addAttribute(JOGGABLE_ATTRIBUTE, feature.isJoggableEnabled());
        writer.addAttribute(IS_VARIABLE_ATTRIBUTE, this.getFeatureIsVariableForWriting(feature));
        writer.addAttribute("id", feature.getId());
    }

    void readGeomFeature(GeomFeature feature, PersistReader reader) {
        feature.setShowAxes(reader.getBooleanAttribute(SHOW_AXES_ATTRIBUTE));
        boolean persistedIsVariable = reader.getBooleanAttribute(IS_VARIABLE_ATTRIBUTE);
        feature.setPersistedIsVariable(persistedIsVariable);
        feature.setIsVariable(this.getFeatureIsVariableForReading(persistedIsVariable), false);
        feature.setJoggableEnabled(reader.getBooleanAttribute(JOGGABLE_ATTRIBUTE));
    }

    void pre3_0_GeomBase(PersistReader reader, GeomFeature result) {
        if (reader.isNode("javax.swing.tree.DefaultMutableTreeNode")) {
            reader.moveToChildNode();
            this.loadDefaultMutableTreeNodeFeature(result, reader);
            reader.moveToParentNode();
        } else if (reader.isNode("gui.geom.JoggableGeomFeature")) {
            reader.moveToChildNode();
            this.loadJoggableGeomFeature((JoggableGeomFeature)result, reader);
            reader.moveToParentNode();
        } else if (reader.isNode("gui.geom.GeomFeature")) {
            reader.moveToChildNode();
            this.loadGeomFeature(result, reader);
            reader.moveToParentNode();
        }
    }

    abstract boolean getFeatureIsVariableForWriting(GeomFeature var1);

    abstract boolean getFeatureIsVariableForReading(boolean var1);

    abstract boolean getFeatureIsVariableForReadingLegacy(boolean var1);

    private void loadDefaultMutableTreeNodeFeature(GeomFeature result, PersistReader reader) {
        while (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            if (reader.isNode("children")) {
                while (reader.hasMoreNodes()) {
                    reader.moveToChildNode();
                    GeomPoseNode poseNode = (GeomPoseNode)((Object)reader.convertContainedValue(GeomPoseNode.class));
                    poseNode.setIsVariable(poseNode.persistedIsVariable(), false);
                    result.add((MutableTreeNode)((Object)poseNode));
                    reader.moveToParentNode();
                }
            }
            reader.moveToParentNode();
        }
    }

    private void loadJoggableGeomFeature(JoggableGeomFeature result, PersistReader reader) {
        while (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            if (reader.isNode("joggableEnabled")) {
                result.setJoggableEnabled(reader.getBooleanValue());
            }
            reader.moveToParentNode();
        }
    }

    private void loadGeomFeature(GeomFeature result, PersistReader reader) {
        while (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            if (reader.isNode(IS_VARIABLE_ATTRIBUTE)) {
                boolean persistedIsVariable = reader.getBooleanValue();
                result.setPersistedIsVariable(persistedIsVariable);
                result.setIsVariable(this.getFeatureIsVariableForReadingLegacy(persistedIsVariable), false);
            } else if (reader.isNode(SHOW_AXES_ATTRIBUTE)) {
                result.setShowAxes(reader.getBooleanValue());
            } else if (reader.isNode("name")) {
                result.setName(reader.getStringValue());
            } else if (reader.isNode("transform")) {
                reader.moveToChildNode();
                double[] values = reader.getDoubleArrayValue();
                Transform3D newTransform = new Transform3D(values);
                result.setNewTransform(newTransform);
                reader.moveToParentNode();
            }
            reader.moveToParentNode();
        }
    }
}

