/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.polyscope.persistence.installation.geom;

import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.robot.configuration.RobotConfigurationProvider;
import com.ur.polyscope.robot.configuration.controller.ConfigurationState;
import gui.geom.CameraView;
import gui.geom.WorldTransform;
import javax.inject.Inject;

public class CameraViewConversionStrategy
extends ConversionStrategyTemplate<CameraView> {
    private RobotConfigurationProvider robotConfigurationProvider;
    private ConfigurationState configurationState;

    @Inject
    public CameraViewConversionStrategy(RobotConfigurationProvider robotConfigurationProvider, ConfigurationState configurationState) {
        super(CameraView.class);
        this.robotConfigurationProvider = robotConfigurationProvider;
        this.configurationState = configurationState;
    }

    public void marshal(CameraView toMarshal, PersistWriter writer) {
        writer.writeNodeWithTypeAndValue("worldTransform", (Object)toMarshal.getWorldTransform());
    }

    public CameraView unmarshal(PersistReader reader) {
        WorldTransform worldTransform = null;
        if (reader.isNode("CameraView")) {
            reader.moveToChildNode();
            worldTransform = (WorldTransform)((Object)reader.convertContainedValue(WorldTransform.class));
            reader.moveToParentNode();
        } else if (reader.isNode("cameraView")) {
            while (reader.hasMoreNodes()) {
                reader.moveToChildNode();
                if (reader.isNode("gui.geom.CameraView")) {
                    reader.moveToChildNode();
                    while (reader.hasMoreNodes()) {
                        reader.moveToChildNode();
                        if (reader.isNode("wt")) {
                            worldTransform = (WorldTransform)((Object)reader.convertContainedValue(WorldTransform.class));
                        }
                        reader.moveToParentNode();
                    }
                    reader.moveToParentNode();
                }
                reader.moveToParentNode();
            }
        }
        return new CameraView(worldTransform, this.robotConfigurationProvider, this.configurationState);
    }
}

