/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.polyscope.persistence.installation.geom;

import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.view.polyscope.persistence.installation.geom.BaseGeomConversionStrategy;
import com.ur.view.polyscope.persistence.installation.geom.GeomPoseNodeConversionStrategy;
import gui.geom.GeomFeatureFactory;
import gui.polyscope.setup.treenodes.geom.GeomLineNode;
import gui.polyscope.setup.treenodes.geom.GeomPoseNode;
import java.util.UUID;
import javax.inject.Inject;
import javax.swing.tree.MutableTreeNode;

public abstract class GeomLineNodeConversionStrategy
extends BaseGeomConversionStrategy<GeomLineNode> {
    final GeomFeatureFactory entityFactory;

    @Inject
    public GeomLineNodeConversionStrategy(GeomFeatureFactory entityFactory) {
        super(GeomLineNode.class);
        this.entityFactory = entityFactory;
    }

    public void marshal(GeomLineNode toMarshal, PersistWriter writer) {
        writer.startNode("GeomLineNode");
        writer.addAttribute("name", toMarshal.getName());
        this.writeGeomFeature((GeomFeature)toMarshal, writer);
        this.writeGeomNodePoint(writer, toMarshal, "firstPoint", 0);
        this.writeGeomNodePoint(writer, toMarshal, "secondPoint", 1);
        writer.endNode();
    }

    public GeomLineNode unmarshal(PersistReader reader) {
        GeomLineNode result = null;
        if (reader.isNode("gui.polyscope.setup.treenodes.geom.GeomLineNode")) {
            result = this.entityFactory.createLineNode();
            this.pre_3_0(reader, result);
        } else {
            reader.moveToChildNode();
            result = this.entityFactory.createLineNode(reader.getStringAttribute("name"), reader.getUUIDAttribute("id", UUID.randomUUID()));
            this.readGeomFeature((GeomFeature)result, reader);
            result.add((MutableTreeNode)((Object)this.readGeomPoseNode(reader)));
            result.add((MutableTreeNode)((Object)this.readGeomPoseNode(reader)));
            reader.moveToParentNode();
        }
        return result;
    }

    abstract GeomPoseNodeConversionStrategy getGeomPoseNodeConversionStrategy();

    abstract GeomPoseNode readGeomPoseNode(PersistReader var1);

    private void writeGeomNodePoint(PersistWriter writer, GeomLineNode toPersist, String nodeName, int i) {
        writer.startNode(nodeName);
        this.getGeomPoseNodeConversionStrategy().marshal((GeomPoseNode)((Object)toPersist.getChildAt(i)), writer);
        writer.endNode();
    }

    private void pre_3_0(PersistReader reader, GeomLineNode result) {
        while (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            if (!reader.isNode("gui.polyscope.setup.treenodes.geom.GeomLineNode")) {
                super.pre3_0_GeomBase(reader, (GeomFeature)result);
            }
            reader.moveToParentNode();
        }
    }
}

