/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.polyscope.persistence.installation.geom;

import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.view.polyscope.persistence.installation.geom.BaseGeomConversionStrategy;
import com.ur.view.polyscope.persistence.installation.geom.GeomPoseNodeConversionStrategy;
import gui.geom.GeomFeatureFactory;
import gui.polyscope.setup.treenodes.geom.GeomPlaneNode;
import gui.polyscope.setup.treenodes.geom.GeomPoseNode;
import java.util.ArrayList;
import java.util.UUID;
import javax.inject.Inject;
import javax.swing.tree.MutableTreeNode;

public abstract class GeomPlaneNodeConversionStrategy
extends BaseGeomConversionStrategy<GeomPlaneNode> {
    final GeomFeatureFactory entityFactory;
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final String FIRST_POINT = "firstPoint";
    private static final String SECOND_POINT = "secondPoint";
    private static final String THIRD_POINT = "thirdPoint";
    private static final String USER_HAS_POINTS = "userHasPoints";
    private static final String USER_FIRST_POINT = "userFirstPoint";
    private static final String USER_SECOND_POINT = "userSecondPoint";
    private static final String USER_THIRD_POINT = "userThirdPoint";

    @Inject
    public GeomPlaneNodeConversionStrategy(GeomFeatureFactory entityFactory) {
        super(GeomPlaneNode.class);
        this.entityFactory = entityFactory;
    }

    public void marshal(GeomPlaneNode toPersist, PersistWriter writer) {
        writer.startNode("GeomPlaneNode");
        writer.addAttribute(NAME, toPersist.getName());
        writer.addAttribute(USER_HAS_POINTS, toPersist.getHasUserPoints());
        this.writeGeomFeature((GeomFeature)toPersist, writer);
        this.writeGeomNodePoint(writer, FIRST_POINT, (GeomPoseNode)((Object)toPersist.getChildAt(0)));
        this.writeGeomNodePoint(writer, SECOND_POINT, (GeomPoseNode)((Object)toPersist.getChildAt(1)));
        this.writeGeomNodePoint(writer, THIRD_POINT, (GeomPoseNode)((Object)toPersist.getChildAt(2)));
        if (toPersist.getHasUserPoints()) {
            this.writeGeomNodePoint(writer, USER_FIRST_POINT, toPersist.getUserPoints().get(0));
            this.writeGeomNodePoint(writer, USER_SECOND_POINT, toPersist.getUserPoints().get(1));
            this.writeGeomNodePoint(writer, USER_THIRD_POINT, toPersist.getUserPoints().get(2));
        }
        writer.endNode();
    }

    public GeomPlaneNode unmarshal(PersistReader reader) {
        GeomPlaneNode result;
        if (reader.isNode("gui.polyscope.setup.treenodes.geom.GeomPlaneNode")) {
            result = this.entityFactory.createPlaneNode();
            this.pre_3_0(reader, result);
        } else {
            reader.moveToChildNode();
            result = this.entityFactory.createPlaneNode(reader.getStringAttribute(NAME), reader.getUUIDAttribute(ID, UUID.randomUUID()));
            result.setHasUserPoints(reader.getBooleanAttribute(USER_HAS_POINTS, false));
            this.readGeomFeature((GeomFeature)result, reader);
            result.add((MutableTreeNode)((Object)this.readGeomPoseNode(reader)));
            result.add((MutableTreeNode)((Object)this.readGeomPoseNode(reader)));
            result.add((MutableTreeNode)((Object)this.readGeomPoseNode(reader)));
            if (result.getHasUserPoints()) {
                ArrayList<GeomPoseNode> list = new ArrayList<GeomPoseNode>();
                list.add(this.readGeomPoseNode(reader));
                list.add(this.readGeomPoseNode(reader));
                list.add(this.readGeomPoseNode(reader));
                result.setUserPoints(list);
                result.setManualEdited(false);
            } else if (result.isDefined()) {
                result.setManualEdited(true);
            }
            reader.moveToParentNode();
        }
        return result;
    }

    abstract GeomPoseNodeConversionStrategy getGeomPoseNodeConversionStrategy();

    abstract GeomPoseNode readGeomPoseNode(PersistReader var1);

    private void writeGeomNodePoint(PersistWriter writer, String nodeName, GeomPoseNode poseNode) {
        writer.startNode(nodeName);
        this.getGeomPoseNodeConversionStrategy().marshal(poseNode, writer);
        writer.endNode();
    }

    private void pre_3_0(PersistReader reader, GeomPlaneNode result) {
        while (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            if (!reader.isNode("gui.polyscope.setup.treenodes.geom.GeomPlaneNode")) {
                super.pre3_0_GeomBase(reader, (GeomFeature)result);
            }
            reader.moveToParentNode();
        }
    }
}

