/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.polyscope.persistence.installation.geom;

import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.geomfeature.urcaps.FeatureContributorInfoPersister;
import com.ur.polyscope.installation.urcap.contributor.ContributorInfo;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.valueobjects.value.ToolPosition;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.view.polyscope.persistence.installation.geom.BaseGeomConversionStrategy;
import gui.geom.GeomFeatureFactory;
import gui.polyscope.setup.treenodes.geom.GeomPoseNode;
import gui.polyscope.setup.treenodes.geom.GeomPoseNodeContributed;
import gui.program.position.LegacyPosition;
import java.util.UUID;
import javax.inject.Inject;
import javax.vecmath.Point3d;

public abstract class GeomPoseNodeConversionStrategy
extends BaseGeomConversionStrategy<GeomPoseNode> {
    private final GeomFeatureFactory entityFactory;
    private final FeatureContributorInfoPersister featureContributorInfoPersister;
    private static final String HIDDEN_SUB_FEATURE = "hiddenSubFeature";

    @Inject
    public GeomPoseNodeConversionStrategy(GeomFeatureFactory entityFactory, FeatureContributorInfoPersister featureContributorInfoPersister) {
        super(GeomPoseNode.class);
        this.entityFactory = entityFactory;
        this.featureContributorInfoPersister = featureContributorInfoPersister;
    }

    public void marshal(GeomPoseNode geomPoseNode, PersistWriter writer) {
        writer.startNode("GeomPoseNode");
        this.writeGeomFeature((GeomFeature)geomPoseNode, writer);
        writer.addAttribute("name", geomPoseNode.getName());
        if (geomPoseNode.isHiddenSubFeature()) {
            writer.addAttribute(HIDDEN_SUB_FEATURE, geomPoseNode.isHiddenSubFeature());
        }
        LegacyPosition position = geomPoseNode.getPositionReference();
        writer.createNodeWithValueAttribute("jointPositionVector", position.getJointPositionVector().getJoints());
        writer.createNodeWithValueAttribute("toolPosition", this.asDouble(position.getToolPosition()));
        writer.createNodeWithValueAttribute("toolAxisAngle", this.asDouble(position.getToolAxisAngle()));
        Pose6d tcpOffset = geomPoseNode.getTcpOffset();
        if (tcpOffset != null) {
            writer.createNodeWithValueAttribute("tcpOffset", tcpOffset.toArray());
        }
        if (geomPoseNode instanceof GeomPoseNodeContributed) {
            GeomPoseNodeContributed contributed = (GeomPoseNodeContributed)geomPoseNode;
            this.featureContributorInfoPersister.write(writer, contributed.getContributorInfo());
        }
        writer.endNode();
    }

    private double[] asDouble(Point3d point) {
        return new double[]{point.x, point.y, point.z};
    }

    public GeomPoseNode unmarshal(PersistReader reader) {
        GeomPoseNode result;
        if (reader.isNode("gui.polyscope.setup.treenodes.geom.GeomPoseNode")) {
            result = this.entityFactory.createPoseNode(false, false);
            this.pre_3_0_unmarshal(reader, result);
        } else {
            result = this.unmarshalGeomPoseNode(reader);
        }
        return result;
    }

    private GeomPoseNode unmarshalGeomPoseNode(PersistReader reader) {
        reader.moveToChildNode();
        String name = reader.getStringAttribute("name");
        UUID id = reader.getUUIDAttribute("id", UUID.randomUUID());
        FeatureProperties featureProperties = this.readFeatureProperties(reader);
        PoseProperties poseProperties = this.readPoseProperties(reader);
        GeomPoseNode result = this.createGeomPoseNode(name, id, poseProperties);
        this.setFeatureProperties(featureProperties, result);
        reader.moveToParentNode();
        return result;
    }

    private FeatureProperties readFeatureProperties(PersistReader reader) {
        boolean hiddenSubFeature = reader.getBooleanAttribute(HIDDEN_SUB_FEATURE, false);
        boolean showAxes = reader.getBooleanAttribute("showAxes");
        boolean persistedIsVariable = reader.getBooleanAttribute("isVariable");
        boolean joggable = reader.getBooleanAttribute("joggable");
        return new FeatureProperties(hiddenSubFeature, showAxes, persistedIsVariable, joggable);
    }

    private PoseProperties readPoseProperties(PersistReader reader) {
        JointPositionVector jointsPositionVector = new JointPositionVector();
        Point3d toolPosition = new Point3d();
        Point3d toolAxisAngle = new Point3d();
        Pose6d tcpOffset = null;
        ContributorInfo contributorInfo = null;
        while (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            if (reader.isNode("jointPositionVector")) {
                jointsPositionVector = new JointPositionVector(reader.getDoubleArrayValueAttribute());
            } else if (reader.isNode("toolPosition")) {
                toolPosition = new Point3d(reader.getDoubleArrayValueAttribute());
            } else if (reader.isNode("toolAxisAngle")) {
                toolAxisAngle = new Point3d(reader.getDoubleArrayValueAttribute());
            } else if (reader.isNode("tcpOffset")) {
                tcpOffset = new Pose6d(reader.getDoubleArrayValueAttribute());
            } else if (reader.getNodeName().equals("ContributorInfo")) {
                contributorInfo = this.featureContributorInfoPersister.read(reader);
            }
            reader.moveToParentNode();
        }
        return new PoseProperties(jointsPositionVector, toolPosition, toolAxisAngle, tcpOffset, contributorInfo);
    }

    private GeomPoseNode createGeomPoseNode(String name, UUID id, PoseProperties poseProperties) {
        GeomPoseNode result;
        if (poseProperties.contributorInfo != null) {
            result = this.createContributedNode(name, poseProperties);
            result.setId(id);
        } else {
            result = this.entityFactory.createPoseNode(false, false, name, id);
            result.setPosition(poseProperties.jointsPositionVector, poseProperties.toolPosition, poseProperties.toolAxisAngle);
        }
        if (poseProperties.tcpOffset != null) {
            result.setTcpOffset(poseProperties.tcpOffset);
        }
        return result;
    }

    private void setFeatureProperties(FeatureProperties featureProperties, GeomPoseNode result) {
        result.setHiddenSubFeature(featureProperties.hiddenSubFeature);
        result.setShowAxes(featureProperties.showAxes);
        result.setPersistedIsVariable(featureProperties.persistedIsVariable);
        result.setIsVariable(this.getFeatureIsVariableForReading(featureProperties.persistedIsVariable), false);
        result.setJoggableEnabled(featureProperties.joggable);
    }

    private GeomPoseNode createContributedNode(String name, PoseProperties poseProperties) {
        ToolPosition pose = new ToolPosition(poseProperties.toolPosition.getX(), poseProperties.toolPosition.getY(), poseProperties.toolPosition.getZ(), poseProperties.toolAxisAngle.getX(), poseProperties.toolAxisAngle.getY(), poseProperties.toolAxisAngle.getZ());
        GeomPoseNode result = this.entityFactory.createPoseNode(name, pose, poseProperties.jointsPositionVector, poseProperties.contributorInfo);
        return result;
    }

    private void pre_3_0_unmarshal(PersistReader reader, GeomPoseNode result) {
        while (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            if (reader.isNode("gui.polyscope.setup.treenodes.geom.GeomPoseNode")) {
                reader.moveToChildNode();
                this.loadGeomPoseNode(result, reader);
                reader.moveToParentNode();
            } else {
                super.pre3_0_GeomBase(reader, (GeomFeature)result);
            }
            reader.moveToParentNode();
        }
    }

    private void loadGeomPoseNode(GeomPoseNode result, PersistReader reader) {
        while (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            if (reader.isNode("position")) {
                this.loadPositionIntoGeomPoseNode(result, reader);
            } else if (reader.isNode("showAxes")) {
                result.setShowAxes(reader.getBooleanValue());
            }
            reader.moveToParentNode();
        }
    }

    private void loadPositionIntoGeomPoseNode(GeomPoseNode result, PersistReader reader) {
        JointPositionVector joints = new JointPositionVector();
        Point3d toolPosition = new Point3d();
        Point3d toolAxisAngle = new Point3d();
        while (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            if (reader.isNode("jpv")) {
                reader.moveToChildNode();
                joints = new JointPositionVector(reader.getDoubleArrayValue());
                reader.moveToParentNode();
            } else if (reader.isNode("toolPosition")) {
                toolPosition.x = this.readNextContainedDouble(reader);
                toolPosition.y = this.readNextContainedDouble(reader);
                toolPosition.z = this.readNextContainedDouble(reader);
            } else if (reader.isNode("toolAxisAngle")) {
                toolAxisAngle.x = this.readNextContainedDouble(reader);
                toolAxisAngle.y = this.readNextContainedDouble(reader);
                toolAxisAngle.z = this.readNextContainedDouble(reader);
            }
            reader.moveToParentNode();
        }
        result.setPosition(joints, toolPosition, toolAxisAngle);
    }

    private double readNextContainedDouble(PersistReader reader) {
        reader.moveToChildNode();
        double value = reader.getDoubleValue();
        reader.moveToParentNode();
        return value;
    }

    private static class FeatureProperties {
        private final boolean hiddenSubFeature;
        private final boolean showAxes;
        private final boolean persistedIsVariable;
        private final boolean joggable;

        FeatureProperties(boolean hiddenSubFeature, boolean showAxes, boolean persistedIsVariable, boolean joggable) {
            this.hiddenSubFeature = hiddenSubFeature;
            this.showAxes = showAxes;
            this.persistedIsVariable = persistedIsVariable;
            this.joggable = joggable;
        }
    }

    private static class PoseProperties {
        private final JointPositionVector jointsPositionVector;
        private final Point3d toolPosition;
        private final Point3d toolAxisAngle;
        private final Pose6d tcpOffset;
        private final ContributorInfo contributorInfo;

        PoseProperties(JointPositionVector jointsPositionVector, Point3d toolPosition, Point3d toolAxisAngle, Pose6d tcpOffset, ContributorInfo contributorInfo) {
            this.jointsPositionVector = jointsPositionVector;
            this.toolPosition = toolPosition;
            this.toolAxisAngle = toolAxisAngle;
            this.tcpOffset = tcpOffset;
            this.contributorInfo = contributorInfo;
        }
    }
}

