/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.polyscope.persistence.installation.geom;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.installation.InstallationComponentConversionStrategy;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.polyscope.persistence.ConversionStrategy;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.robot.configuration.RobotConfigurationProvider;
import com.ur.polyscope.robot.configuration.controller.ConfigurationState;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.view.polyscope.persistence.installation.geom.BaseViewConversionStrategy;
import com.ur.view.polyscope.persistence.installation.geom.CameraViewConversionStrategy;
import com.ur.view.polyscope.persistence.installation.geom.GeomLineNodeConversionStrategy;
import com.ur.view.polyscope.persistence.installation.geom.GeomPlaneNodeConversionStrategy;
import com.ur.view.polyscope.persistence.installation.geom.GeomPoseNodeConversionStrategy;
import com.ur.view.polyscope.persistence.installation.geom.ToolViewConversionStrategy;
import gui.geom.BaseView;
import gui.geom.CameraView;
import gui.geom.ToolView;
import gui.polyscope.setup.treenodes.geom.GeomLineNode;
import gui.polyscope.setup.treenodes.geom.GeomPlaneNode;
import gui.polyscope.setup.treenodes.geom.GeomPoseNode;
import gui.polyscope.setup.treenodes.geom.SetupFeatureContainerNode;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.tree.MutableTreeNode;

public abstract class SetupFeatureContainerNodeConversionStrategy
extends ConversionStrategyTemplate<SetupFeatureContainerNode>
implements InstallationComponentConversionStrategy<SetupFeatureContainerNode> {
    public static final String FEATURE_CONTAINER_NODE = "SetupFeatureContainerNode";
    private final GeomPoseNodeConversionStrategy poseNodeConversionStrategy;
    private final GeomLineNodeConversionStrategy lineNodeConversionStrategy;
    private final GeomPlaneNodeConversionStrategy planeNodeConversionStrategy;
    BaseView baseViewFeature;
    private SetupFeatureContainerNode featureContainer;
    private ControllerInterface controllerInterface;
    private RobotInstallationSite robotInstallationSite;
    private RobotConfigurationProvider robotConfigurationProvider;
    private ConfigurationState configurationState;

    @Inject
    public SetupFeatureContainerNodeConversionStrategy(BaseView baseViewFeature, SetupFeatureContainerNode featureContainer, GeomPoseNodeConversionStrategy poseNodeConversionStrategy, GeomLineNodeConversionStrategy lineNodeConversionStrategy, GeomPlaneNodeConversionStrategy planeNodeConversionStrategy, ControllerInterface controllerInterface, RobotInstallationSite robotInstallationSite, RobotConfigurationProvider robotConfigurationProvider, ConfigurationState configurationState) {
        super(SetupFeatureContainerNode.class);
        this.baseViewFeature = baseViewFeature;
        this.featureContainer = featureContainer;
        this.poseNodeConversionStrategy = poseNodeConversionStrategy;
        this.lineNodeConversionStrategy = lineNodeConversionStrategy;
        this.planeNodeConversionStrategy = planeNodeConversionStrategy;
        this.controllerInterface = controllerInterface;
        this.robotInstallationSite = robotInstallationSite;
        this.robotConfigurationProvider = robotConfigurationProvider;
        this.configurationState = configurationState;
    }

    public void marshal(SetupFeatureContainerNode toPersist, PersistWriter writer) {
        this.writeGeomFeature(writer, (GeomFeature)toPersist.getCameraView());
        int i = 0;
        while (i < toPersist.getChildCount()) {
            this.writeGeomFeature(writer, (GeomFeature)toPersist.getChildAt(i));
            ++i;
        }
    }

    abstract BaseViewConversionStrategy getBaseViewConversionStrategy(BaseView var1);

    private void writeGeomFeature(PersistWriter writer, GeomFeature childAt) {
        if (childAt instanceof CameraView) {
            writer.startNode("CameraView");
            new CameraViewConversionStrategy(this.robotConfigurationProvider, this.configurationState).marshal((CameraView)childAt, writer);
            writer.endNode();
        } else if (childAt instanceof ToolView) {
            writer.startNode("ToolView");
            new ToolViewConversionStrategy(this.controllerInterface, this.robotInstallationSite).marshal((ToolView)childAt, writer);
            writer.endNode();
        } else if (childAt instanceof BaseView) {
            writer.startNode("BaseView");
            this.getBaseViewConversionStrategy((BaseView)childAt).marshal((BaseView)childAt, writer);
            writer.endNode();
        } else if (childAt instanceof GeomPoseNode) {
            writer.startNode("GeomPoseNode");
            this.poseNodeConversionStrategy.marshal((GeomPoseNode)childAt, writer);
            writer.endNode();
        } else if (childAt instanceof GeomLineNode) {
            writer.startNode("GeomLineNode");
            this.lineNodeConversionStrategy.marshal((GeomLineNode)childAt, writer);
            writer.endNode();
        } else if (childAt instanceof GeomPlaneNode) {
            writer.startNode("GeomPlaneNode");
            this.planeNodeConversionStrategy.marshal((GeomPlaneNode)childAt, writer);
            writer.endNode();
        }
    }

    public SetupFeatureContainerNode unmarshal(PersistReader reader) {
        if (reader.isNode("gui.polyscope.setup.treenodes.geom.SetupFeatureContainerNode")) {
            this.pre_3_0(reader, this.featureContainer);
        } else if (reader.isNode("featureContainer") || reader.isNode("GeomFeatures")) {
            reader.moveToChildNode();
            if (reader.isNode(FEATURE_CONTAINER_NODE)) {
                while (reader.hasMoreNodes()) {
                    this.readGeomFeature(reader, this.featureContainer);
                }
            } else {
                reader.moveToChildNode();
                reader.nextNode();
                reader.moveToChildNode();
                while (reader.hasMoreNodes()) {
                    this.readGeomFeature(reader, this.featureContainer);
                }
                reader.moveToParentNode();
                reader.moveToParentNode();
            }
            reader.moveToParentNode();
        } else if (reader.isNode("Features")) {
            while (reader.hasMoreNodes()) {
                this.readGeomFeature(reader, this.featureContainer);
            }
        }
        return this.featureContainer;
    }

    private void readGeomFeature(PersistReader reader, SetupFeatureContainerNode result) {
        reader.moveToChildNode();
        String nodeName = reader.getNodeName();
        if (EqualsUtil.equalsOneOf((Object)nodeName, (Object[])new String[]{"gui.geom.CameraView", "CameraView"})) {
            CameraView view = new CameraViewConversionStrategy(this.robotConfigurationProvider, this.configurationState).unmarshal(reader);
            result.setWorldFeatures(view, view.getWorldTransform());
        } else if (EqualsUtil.equalsOneOf((Object)nodeName, (Object[])new String[]{"gui.geom.ToolView", "ToolView"})) {
            new ToolViewConversionStrategy(result.getToolViewFeature(), this.controllerInterface, this.robotInstallationSite).unmarshal(reader);
        } else if (EqualsUtil.equalsOneOf((Object)nodeName, (Object[])new String[]{"gui.geom.BaseView", "BaseView"})) {
            this.getBaseViewConversionStrategy(result.getBaseViewFeature()).unmarshal(reader);
        } else if (EqualsUtil.equalsOneOf((Object)nodeName, (Object[])new String[]{"gui.polyscope.setup.treenodes.geom.GeomPoseNode", "GeomPoseNode"})) {
            result.add((MutableTreeNode)((Object)this.poseNodeConversionStrategy.unmarshal(reader)));
        } else if (EqualsUtil.equalsOneOf((Object)nodeName, (Object[])new String[]{"gui.polyscope.setup.treenodes.geom.GeomLineNode", "GeomLineNode"})) {
            result.add((MutableTreeNode)((Object)this.lineNodeConversionStrategy.unmarshal(reader)));
        } else if (EqualsUtil.equalsOneOf((Object)nodeName, (Object[])new String[]{"gui.polyscope.setup.treenodes.geom.GeomPlaneNode", "GeomPlaneNode"})) {
            result.add((MutableTreeNode)((Object)this.planeNodeConversionStrategy.unmarshal(reader)));
        }
        reader.moveToParentNode();
    }

    private void pre_3_0(PersistReader reader, SetupFeatureContainerNode result) {
        while (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            if (reader.isNode("javax.swing.tree.DefaultMutableTreeNode")) {
                reader.moveToChildNode();
                this.loadChildren(reader, result);
                reader.moveToParentNode();
            }
            reader.moveToParentNode();
        }
    }

    private void loadChildren(PersistReader reader, SetupFeatureContainerNode result) {
        while (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            if (reader.isNode("children")) {
                while (reader.hasMoreNodes()) {
                    reader.moveToChildNode();
                    if (EqualsUtil.equalsOneOf((Object)reader.getNodeName(), (Object[])new String[]{"gui.geom.ToolView", "ToolView"})) {
                        reader.convertContainedValue((Object)result, ToolView.class, (ConversionStrategy)new ToolViewConversionStrategy(result.getToolViewFeature(), this.controllerInterface, this.robotInstallationSite));
                    } else if (EqualsUtil.equalsOneOf((Object)reader.getNodeName(), (Object[])new String[]{"gui.geom.BaseView", "BaseView"})) {
                        reader.convertContainedValue((Object)result, BaseView.class, (ConversionStrategy)this.getBaseViewConversionStrategy(result.getBaseViewFeature()));
                    } else if (EqualsUtil.equalsOneOf((Object)reader.getNodeName(), (Object[])new String[]{"gui.polyscope.setup.treenodes.geom.GeomPoseNode", "GeomPoseNode"})) {
                        result.add((MutableTreeNode)reader.convertContainedValue(GeomPoseNode.class));
                    } else if (EqualsUtil.equalsOneOf((Object)reader.getNodeName(), (Object[])new String[]{"gui.polyscope.setup.treenodes.geom.GeomLineNode", "GeomLineNode"})) {
                        result.add((MutableTreeNode)reader.convertContainedValue(GeomLineNode.class));
                    } else if (EqualsUtil.equalsOneOf((Object)reader.getNodeName(), (Object[])new String[]{"gui.polyscope.setup.treenodes.geom.GeomPlaneNode", "GeomPlaneNode"})) {
                        result.add((MutableTreeNode)reader.convertContainedValue(GeomPlaneNode.class));
                    }
                    reader.moveToParentNode();
                }
            }
            reader.moveToParentNode();
        }
    }

    public Map<String, Class<? extends SetupFeatureContainerNode>> getClassAliases(boolean forMarshalling) {
        return Collections.singletonMap("Features", SetupFeatureContainerNode.class);
    }

    public Map<String, Class<? extends SetupFeatureContainerNode>> getTypeAliases(boolean forMarshalling) {
        return new LinkedHashMap<String, Class<? extends SetupFeatureContainerNode>>(){
            {
                this.put("Features", SetupFeatureContainerNode.class);
                this.put("featuresContainer", SetupFeatureContainerNode.class);
                this.put("GeomFeatures", SetupFeatureContainerNode.class);
                this.put("gui.polyscope.setup.treenodes.geom.SetupFeatureContainerNode", SetupFeatureContainerNode.class);
            }
        };
    }
}

