/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.polyscope.persistence.installation.geom;

import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.util.logging.Log;
import com.ur.view.polyscope.persistence.installation.geom.BaseGeomConversionStrategy;
import gui.geom.ToolView;
import javax.inject.Inject;

public class ToolViewConversionStrategy
extends BaseGeomConversionStrategy<ToolView> {
    private ToolView toolViewFeature;
    private ControllerInterface controllerInterface;
    private RobotInstallationSite robotInstallationSite;

    @Inject
    public ToolViewConversionStrategy(ControllerInterface controllerInterface, RobotInstallationSite robotInstallationSite) {
        this(null, controllerInterface, robotInstallationSite);
    }

    public ToolViewConversionStrategy(ToolView toolViewFeature, ControllerInterface controllerInterface, RobotInstallationSite robotInstallationSite) {
        super(ToolView.class);
        this.toolViewFeature = toolViewFeature;
        this.controllerInterface = controllerInterface;
        this.robotInstallationSite = robotInstallationSite;
    }

    public void marshal(ToolView toMarshal, PersistWriter writer) {
        writer.startNode("ToolView");
        this.writeGeomFeature((GeomFeature)toMarshal, writer);
        writer.endNode();
    }

    public ToolView unmarshal(PersistReader reader) {
        ToolView result = this.toolViewFeature;
        if (result == null) {
            Log.error((String)"Should never perform unmarshalling of Tool without toolViewFeature being set via constructor");
            result = new ToolView(this.controllerInterface, this.robotInstallationSite);
        }
        if (reader.isNode("gui.geom.ToolView")) {
            this.pre_3_0(reader, result);
        } else {
            reader.moveToChildNode();
            this.readGeomFeature((GeomFeature)result, reader);
            reader.moveToParentNode();
        }
        return result;
    }

    @Override
    boolean getFeatureIsVariableForWriting(GeomFeature feature) {
        return feature.isVariable();
    }

    @Override
    boolean getFeatureIsVariableForReading(boolean persistedIsVariable) {
        return persistedIsVariable;
    }

    @Override
    boolean getFeatureIsVariableForReadingLegacy(boolean persistedIsVariable) {
        return persistedIsVariable;
    }

    private void pre_3_0(PersistReader reader, ToolView result) {
        while (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            if (!reader.isNode("gui.geom.ToolView")) {
                super.pre3_0_GeomBase(reader, (GeomFeature)result);
            }
            reader.moveToParentNode();
        }
    }
}

