/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.polyscope.persistence.installation.geom;

import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.view.polyscope.persistence.installation.geom.BaseGeomConversionStrategy;
import gui.geom.WorldTransform;

public class WorldTransformConversionStrategy
extends BaseGeomConversionStrategy<WorldTransform> {
    public WorldTransformConversionStrategy() {
        super(WorldTransform.class);
    }

    public void marshal(WorldTransform transform, PersistWriter writer) {
        writer.startNode("WorldtoMarshal");
        writer.addAttribute("showAxes", transform.getShowAxes());
        writer.addAttribute("isVariable", transform.isVariable());
        writer.addAttribute("baseAngle", transform.getMountingBaseAngle());
        writer.addAttribute("tiltAngle", transform.getMountingTiltAngle());
        writer.endNode();
    }

    public WorldTransform unmarshal(PersistReader reader) {
        WorldTransform result;
        if (reader.isNode("wt")) {
            result = new WorldTransform();
            this.preVersion3_0(reader, result);
        } else if (reader.isNode("worldTransform")) {
            reader.moveToChildNode();
            result = new WorldTransform(reader.getDoubleAttribute("baseAngle"), reader.getDoubleAttribute("tiltAngle"));
            result.setShowAxes(reader.getBooleanAttribute("showAxes"));
            result.setIsVariable(reader.getBooleanAttribute("isVariable"), false);
            reader.moveToParentNode();
        } else {
            result = new WorldTransform();
        }
        return result;
    }

    @Override
    boolean getFeatureIsVariableForWriting(GeomFeature feature) {
        return feature.isVariable();
    }

    @Override
    boolean getFeatureIsVariableForReading(boolean persistedIsVariable) {
        return persistedIsVariable;
    }

    @Override
    boolean getFeatureIsVariableForReadingLegacy(boolean persistedIsVariable) {
        return persistedIsVariable;
    }

    private void preVersion3_0(PersistReader reader, WorldTransform result) {
        while (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            if (reader.isNode("WorldTransform")) {
                result.setMountingBaseAngle(reader.getDoubleAttribute("baseAngle"));
                result.setMountingTiltAngle(reader.getDoubleAttribute("tiltAngle"));
                result.setShowAxes(reader.getBooleanAttribute("showAxes"));
                result.setIsVariable(reader.getBooleanAttribute("isVariable"), false);
            } else if (reader.isNode("gui.geom.WorldTransform")) {
                reader.moveToChildNode();
                this.loadWorldTransform(result, reader);
                reader.moveToParentNode();
            }
            reader.moveToParentNode();
        }
    }

    private void loadWorldTransform(WorldTransform result, PersistReader reader) {
        while (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            if (reader.isNode("mountingBaseAngle")) {
                result.setMountingBaseAngle(reader.getDoubleValue());
            } else if (reader.isNode("mountingTiltAngle")) {
                result.setMountingTiltAngle(reader.getDoubleValue());
            }
            reader.moveToParentNode();
        }
    }
}

