/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.polyscope.persistence.installation.motionsettings;

import com.ur.polyscope.installation.InstallationChangedEvent;
import com.ur.polyscope.installation.InstallationComponent;
import com.ur.polyscope.installation.aspect.InstallationChangeEventAspect;
import com.ur.polyscope.robot.configuration.RobotConfigurationProvider;
import com.ur.polyscope.robot.configuration.RobotID;
import com.ur.polyscope.robot.configuration.robotidentification.RobotTypeIdentifier;
import com.ur.polyscope.scriptwriter.PreambleScript;
import com.ur.polyscope.scriptwriter.ScriptGeneratorLookup;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.view.polyscope.persistence.installation.motionsettings.MotionSettingsConfiguration$AjcClosure1;
import com.ur.view.polyscope.persistence.installation.motionsettings.MotionSettingsSendToController;
import com.ur.view.polyscope.persistence.installation.motionsettings.MotionVersion;
import java.util.Arrays;
import javax.inject.Inject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class MotionSettingsConfiguration
implements InstallationComponent,
PreambleScript {
    private static final String[] ALLOWED_CLASSIC_MOTION;
    private final MotionVersion defaultMotionVersionIfUndefined;
    private MotionVersion motionVersion = MotionVersion.UNDEFINED;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        MotionSettingsConfiguration.ajc$preClinit();
        ALLOWED_CLASSIC_MOTION = new String[]{"UNDEFINED", "UR3", "UR5", "UR7", "UR10", "UR12", "UR16", "UR20", "UR30"};
    }

    @Inject
    public MotionSettingsConfiguration(RobotConfigurationProvider robotConfigurationProvider) {
        this(robotConfigurationProvider.getRobotID());
        this.motionVersion = MotionVersion.JERK_LIMITED;
    }

    public MotionSettingsConfiguration(RobotID robotID) {
        this.defaultMotionVersionIfUndefined = this.isClassicMotionDisabled(robotID) ? MotionVersion.JERK_LIMITED : MotionVersion.CLASSIC;
    }

    public Class<?> getType() {
        return MotionSettingsConfiguration.class;
    }

    public boolean canGenerateScriptCode() {
        return true;
    }

    public void generatePreambleScript(ScriptWriter scriptWriter, ScriptGeneratorLookup scriptGeneratorLookup) {
        scriptWriter.appendLine(MotionSettingsSendToController.getMotionVersionScript(this.getMotionVersionOrDefault()));
    }

    @InstallationChangedEvent
    public void setMotionVersion(MotionVersion version) {
        MotionVersion motionVersion = version;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)((Object)motionVersion));
        Object[] objectArray = new Object[]{this, motionVersion, joinPoint};
        MotionSettingsConfiguration$AjcClosure1 motionSettingsConfiguration$AjcClosure1 = new MotionSettingsConfiguration$AjcClosure1(objectArray);
        InstallationChangeEventAspect.aspectOf().aroundAnnotatedMethod(motionSettingsConfiguration$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public MotionVersion getMotionVersion() {
        return this.motionVersion;
    }

    private MotionVersion getMotionVersionOrDefault() {
        if (this.motionVersion != MotionVersion.UNDEFINED) {
            return this.motionVersion;
        }
        return this.defaultMotionVersionIfUndefined;
    }

    public MotionVersion getDefaultMotionVersionIfUndefined() {
        return this.defaultMotionVersionIfUndefined;
    }

    public boolean isClassicMotionDisabled(RobotTypeIdentifier robotTypeId) {
        String robotTypeName = robotTypeId.getRobotTypeName();
        return this.isClassicMotionDisabled(robotTypeName);
    }

    private boolean isClassicMotionDisabled(RobotID robotId) {
        String robotTypeName = robotId.getTypeAsString();
        return this.isClassicMotionDisabled(robotTypeName);
    }

    private boolean isClassicMotionDisabled(String robotTypeName) {
        return !Arrays.asList(ALLOWED_CLASSIC_MOTION).contains(robotTypeName);
    }

    static final /* synthetic */ void setMotionVersion_aroundBody0(MotionSettingsConfiguration ajc$this, MotionVersion version, JoinPoint joinPoint) {
        ajc$this.motionVersion = version;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MotionSettingsConfiguration.java", MotionSettingsConfiguration.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setMotionVersion", "com.ur.view.polyscope.persistence.installation.motionsettings.MotionSettingsConfiguration", "com.ur.view.polyscope.persistence.installation.motionsettings.MotionVersion", "version", "", "void"), 47);
    }
}

