/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.polyscope.persistence.installation.motionsettings;

import com.ur.i18n.TextResource;
import com.ur.polyscope.installation.InstallationComponentConversionStrategy;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentification;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentificationProvider;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.AggregateDialogCreator;
import com.ur.swing.dialog.WarningMessage;
import com.ur.view.polyscope.persistence.installation.motionsettings.MotionSettingsConfiguration;
import com.ur.view.polyscope.persistence.installation.motionsettings.MotionVersion;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;

public class MotionSettingsConversionStrategy
extends ConversionStrategyTemplate<MotionSettingsConfiguration>
implements InstallationComponentConversionStrategy<MotionSettingsConfiguration> {
    private static final String MOTION_VERSION = "motionVersion";
    private Provider<MotionSettingsConfiguration> provider;
    private final RobotIdentificationProvider robotIdentificationProvider;
    private final ViewContext viewContext;

    @Inject
    public MotionSettingsConversionStrategy(Provider<MotionSettingsConfiguration> provider, RobotIdentificationProvider robotIdentificationProvider, ViewContext viewContext) {
        super(MotionSettingsConfiguration.class);
        this.provider = provider;
        this.robotIdentificationProvider = robotIdentificationProvider;
        this.viewContext = viewContext;
    }

    public void marshal(MotionSettingsConfiguration settings, PersistWriter writer) {
        writer.addAttribute(MOTION_VERSION, (Enum)settings.getMotionVersion());
    }

    public MotionSettingsConfiguration unmarshal(PersistReader reader) {
        MotionSettingsConfiguration settings = (MotionSettingsConfiguration)this.provider.get();
        MotionVersion motionVersion = (MotionVersion)reader.getEnumAttribute(MOTION_VERSION, MotionVersion.class, (Enum)MotionVersion.UNDEFINED);
        motionVersion = this.enforceClassicMotionDisabled(settings, motionVersion);
        settings.setMotionVersion(motionVersion);
        return settings;
    }

    private MotionVersion enforceClassicMotionDisabled(MotionSettingsConfiguration settings, MotionVersion motionVersion) {
        if (motionVersion == MotionVersion.CLASSIC && settings.isClassicMotionDisabled(((RobotIdentification)this.robotIdentificationProvider.get()).getRobotTypeId())) {
            this.showWarningDialog();
            return MotionVersion.UNDEFINED;
        }
        return motionVersion;
    }

    private void showWarningDialog() {
        AggregateDialogCreator dialogCreator = this.viewContext.getDialogCreator();
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        WarningMessage warningMessage = new WarningMessage(textResource.smoothMotionWarningDialogTitle(), textResource.smoothMotionWarningDialogDesc());
        dialogCreator.showWarningMessageDialog(warningMessage, null);
    }

    public Map<String, Class<? extends MotionSettingsConfiguration>> getClassAliases(boolean forMarshalling) {
        return Collections.singletonMap("MotionSettingsConfiguration", MotionSettingsConfiguration.class);
    }

    public Map<String, Class<? extends MotionSettingsConfiguration>> getTypeAliases(boolean forMarshalling) {
        return Collections.singletonMap("MotionSettingsConfiguration", MotionSettingsConfiguration.class);
    }
}

