/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.polyscope.persistence.installation.motionsettings;

import com.ur.i18n.TextResource;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentification;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentificationProvider;
import com.ur.resources.IllustrationImageResource;
import com.ur.resources.ViewImageResource;
import com.ur.swing.FormBuilder;
import com.ur.swing.OnOffSwitch;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.util.swing.HTML;
import com.ur.view.polyscope.persistence.installation.motionsettings.MotionSettingsConfiguration;
import com.ur.view.polyscope.persistence.installation.motionsettings.MotionSettingsSendToController;
import com.ur.view.polyscope.persistence.installation.motionsettings.MotionVersion;
import com.ur.view.polyscope.persistence.installation.smoothtransition.InstallationComponentCardPanel;
import gui.installation.RobotInstallationLookupService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MotionSettingsPanel
extends InstallationComponentCardPanel<MotionSettingsConfiguration> {
    public static final String SHOW_MOTION_SETTINGS_ACTION = "showMotionSettingsAction.G5MotionSettingsPanel";
    public static final String SMOOTH_MOTION_SWITCH = "smoothMotionSwitch." + MotionSettingsPanel.class.getSimpleName();
    private final ViewContext viewContext;
    private final MotionSettingsSendToController sendToController;
    private final RobotIdentificationProvider robotIdentificationProvider;
    private OnOffSwitch toggleSmoothMotion;

    @Inject
    public MotionSettingsPanel(RobotInstallationLookupService lookupService, ViewContext viewContext, MotionSettingsSendToController sendToController, RobotIdentificationProvider robotIdentificationProvider) {
        super(lookupService, viewContext, MotionSettingsConfiguration.class);
        this.viewContext = viewContext;
        this.sendToController = sendToController;
        this.robotIdentificationProvider = robotIdentificationProvider;
        this.initComponents();
    }

    private void initComponents() {
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        WidgetFactory widgetFactory = this.viewContext.createWidgetFactory();
        this.setLayout(new BorderLayout(5, 5));
        this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        JLabel smoothMotionIllustration = widgetFactory.createLabel(IllustrationImageResource.smoothMotionIllustration());
        JLabel velocityLabel = widgetFactory.createLabel(textResource.smoothTransitionVelocity());
        JLabel timeLabel = widgetFactory.createLabel(textResource.smoothTransitionTime());
        JPanel illustrationPanel = new JPanel();
        illustrationPanel.add(smoothMotionIllustration);
        JPanel illustrationLabelPanel = new JPanel();
        illustrationLabelPanel.setLayout(new BoxLayout(illustrationLabelPanel, 1));
        illustrationLabelPanel.add(velocityLabel);
        illustrationLabelPanel.add(timeLabel);
        illustrationPanel.add(illustrationLabelPanel);
        this.toggleSmoothMotion = new OnOffSwitch(textResource.smoothMotionToggle());
        this.toggleSmoothMotion.setName(SMOOTH_MOTION_SWITCH);
        this.toggleSmoothMotion.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.toggleSmoothMotion.addActionListener(this.getToggleSmoothMotionAction(this.toggleSmoothMotion));
        JPanel notApplicableInfoPanel = new JPanel(new FlowLayout(1));
        if (this.isClassicMotionDisabled()) {
            this.toggleSmoothMotion.setEnabled(false);
            notApplicableInfoPanel.add(this.viewContext.createFormBuilder().description(ViewImageResource.formInformation(), textResource.smoothMotionDisabled(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS, FormBuilder.PanelConstraints.SPAN_1_ROW}).end(1).getRow());
        }
        JPanel togglePanel = new JPanel(new FlowLayout(1));
        togglePanel.add((Component)this.toggleSmoothMotion);
        String benefitBulletList = HTML.html((String)("\u2022 " + textResource.smoothMotionBenefitBullet1() + "<br/>" + "\u2022 " + textResource.smoothMotionBenefitBullet2() + "<br/>" + "\u2022 " + textResource.smoothMotionBenefitBullet3()));
        JPanel jPanel = this.viewContext.createFormBuilder().description(textResource.smoothMotionDescription(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS, FormBuilder.PanelConstraints.SPAN_1_ROW}).end(1).description(benefitBulletList, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS, FormBuilder.PanelConstraints.SPAN_4_ROWS}).end(4).description(ViewImageResource.formInformation(), textResource.smoothMotionAffects(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS, FormBuilder.PanelConstraints.SPAN_1_ROW}).end(3).component((JComponent)illustrationPanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS, FormBuilder.PanelConstraints.SPAN_5_ROWS}).end(2).component((JComponent)togglePanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS, FormBuilder.PanelConstraints.SPAN_1_ROW}).end(2).component((JComponent)notApplicableInfoPanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS, FormBuilder.PanelConstraints.SPAN_1_ROW}).end(1).getCardPanel(textResource.motionSettingsTitle());
        this.add(jPanel, "Center");
    }

    private ActionListener getToggleSmoothMotionAction(OnOffSwitch toggle) {
        return actionEvent -> {
            MotionVersion version = toggle.isSelected() ? MotionVersion.JERK_LIMITED : MotionVersion.CLASSIC;
            this.setMotionVersion(version);
        };
    }

    @Override
    protected void updateCard(MotionSettingsConfiguration settings) {
        switch (settings.getMotionVersion()) {
            case UNDEFINED: {
                this.toggleSmoothMotion.setSelected(this.isClassicMotionDisabled());
                break;
            }
            case CLASSIC: {
                this.toggleSmoothMotion.setSelected(false);
                break;
            }
            case JERK_LIMITED: {
                this.toggleSmoothMotion.setSelected(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown enum " + (Object)((Object)settings.getMotionVersion()));
            }
        }
    }

    private void setMotionVersion(MotionVersion motionVersion) {
        MotionSettingsConfiguration configuration = (MotionSettingsConfiguration)this.getInstallationComponent();
        configuration.setMotionVersion(motionVersion);
        this.sendToController(configuration);
    }

    private void sendToController(MotionSettingsConfiguration settings) {
        this.sendToController.setMotionVersion(settings);
    }

    private boolean isClassicMotionDisabled() {
        return ((MotionSettingsConfiguration)this.getInstallationComponent()).isClassicMotionDisabled(((RobotIdentification)this.robotIdentificationProvider.get()).getRobotTypeId());
    }
}

