/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.polyscope.persistence.installation.motionsettings;

import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.view.polyscope.persistence.installation.motionsettings.MotionSettingsConfiguration;
import com.ur.view.polyscope.persistence.installation.motionsettings.MotionVersion;
import java.text.MessageFormat;
import javax.inject.Inject;

public class MotionSettingsSendToController {
    private static final String SET_MOTION_VERSION = "motion_version_set({0})";
    private static final String SET_MOTION_VERSION_MF = "sec setMotionVersion():\n {0}\nend\n";
    private final ControllerInterface controllerInterface;

    @Inject
    public MotionSettingsSendToController(ControllerInterface controllerInterface) {
        this.controllerInterface = controllerInterface;
    }

    public void setMotionVersion(MotionSettingsConfiguration settings) {
        MotionVersion motionVersion = settings.getMotionVersion();
        if (motionVersion == MotionVersion.UNDEFINED) {
            return;
        }
        this.sendToController(motionVersion);
    }

    private void sendToController(MotionVersion motionVersion) {
        String s = MessageFormat.format(SET_MOTION_VERSION_MF, MotionSettingsSendToController.getMotionVersionScript(motionVersion));
        this.controllerInterface.runScript(s);
    }

    public static String getMotionVersionScript(MotionVersion version) {
        return MessageFormat.format(SET_MOTION_VERSION, version.getId());
    }
}

