/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.polyscope.persistence.installation.safehome;

import com.ur.monitor.model.JointPositionVector;
import com.ur.polyscope.installation.InstallationComponentConversionStrategy;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.view.polyscope.persistence.installation.safehome.SafeHomeSettings;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;

public class SafeHomeConversionStrategy
extends ConversionStrategyTemplate<SafeHomeSettings>
implements InstallationComponentConversionStrategy<SafeHomeSettings> {
    static final String ENABLED = "enabled";
    static final String POSITION = "position";
    private Provider<SafeHomeSettings> provider;

    @Inject
    public SafeHomeConversionStrategy(Provider<SafeHomeSettings> provider) {
        super(SafeHomeSettings.class);
        this.provider = provider;
    }

    public void marshal(SafeHomeSettings toMarshal, PersistWriter writer) {
        writer.addAttribute(ENABLED, toMarshal.isEnabled());
        writer.addAttribute(POSITION, toMarshal.getPosition().getJoints());
    }

    public SafeHomeSettings unmarshal(PersistReader reader) {
        SafeHomeSettings safeHomeSettings = (SafeHomeSettings)this.provider.get();
        safeHomeSettings.setEnabled(reader.getBooleanAttribute(ENABLED, true));
        safeHomeSettings.setPosition(new JointPositionVector(reader.getDoubleArrayAttribute(POSITION, SafeHomeSettings.DEFAULT_POSITION)));
        return safeHomeSettings;
    }

    public Map<String, Class<? extends SafeHomeSettings>> getClassAliases(boolean forMarshalling) {
        return Collections.singletonMap("SafeHomeSettings", SafeHomeSettings.class);
    }

    public Map<String, Class<? extends SafeHomeSettings>> getTypeAliases(boolean forMarshalling) {
        return Collections.singletonMap("SafeHomeSettings", SafeHomeSettings.class);
    }
}

