/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.polyscope.persistence.installation.smoothtransition;

import com.ur.i18n.TextResource;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.resources.IllustrationImageResource;
import com.ur.resources.ViewImageResource;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import com.ur.util.logging.Log;
import com.ur.util.swing.HTML;
import com.ur.view.polyscope.persistence.installation.smoothtransition.InstallationComponentCardPanel;
import com.ur.view.polyscope.persistence.installation.smoothtransition.SmoothTransitionSendToController;
import com.ur.view.polyscope.persistence.installation.smoothtransition.SmoothTransitionSettings;
import gui.installation.RobotInstallationLookupService;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import javax.inject.Inject;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SmoothTransitionPanel
extends InstallationComponentCardPanel<SmoothTransitionSettings> {
    public static final String SHOW_SMOOTH_TRANSITION_ACTION = "showSmoothTransitionAction.G5SmoothTransitionPanel";
    public static final String HARD_TRANSITION_RADIO_BUTTON = "hardRadioButton.G5SmoothTransitionPanel";
    public static final String SOFT_TRANSITION_RADIO_BUTTON = "softRadioButton.G5SmoothTransitionPanel";
    private ViewContext viewContext;
    private JRadioButton hardTransitionRadioButton;
    private JRadioButton softTransitionRadioButton;
    private ButtonGroup radioButtons;
    private ControllerInterface controllerInterface;
    private final HelpIdAssigner helpIdAssigner;

    @Inject
    public SmoothTransitionPanel(RobotInstallationLookupService lookupService, ViewContext viewContext, ControllerInterface controllerInterface, HelpIdAssigner helpIdAssigner) {
        super(lookupService, viewContext, SmoothTransitionSettings.class);
        this.viewContext = viewContext;
        this.controllerInterface = controllerInterface;
        this.helpIdAssigner = helpIdAssigner;
        this.initComponents();
        this.initHelpIds();
    }

    private void initComponents() {
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        WidgetFactory widgetFactory = this.viewContext.createWidgetFactory();
        this.setLayout(new BorderLayout(5, 5));
        this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        JLabel smoothTransitionIllustration = widgetFactory.createLabel(IllustrationImageResource.smoothTransitionGraph());
        JLabel velocityLabel = widgetFactory.createLabel(textResource.smoothTransitionVelocity());
        JLabel timeLabel = widgetFactory.createLabel(textResource.smoothTransitionTime());
        JLabel hardTransitionLabel = widgetFactory.createLabel(textResource.smoothTransitionHardTransition());
        JLabel softTransitionLabel = widgetFactory.createLabel(textResource.smoothTransitionSoftTransition());
        hardTransitionLabel.setIcon(ViewImageResource.hardTransitionLegend());
        softTransitionLabel.setIcon(ViewImageResource.softTransitionLegend());
        this.hardTransitionRadioButton = widgetFactory.createRadioButton((Action)((Object)new HardTransitionAction(textResource)));
        this.softTransitionRadioButton = widgetFactory.createRadioButton((Action)((Object)new SoftTransitionAction(textResource)));
        this.radioButtons = new ButtonGroup();
        this.radioButtons.add(this.hardTransitionRadioButton);
        this.radioButtons.add(this.softTransitionRadioButton);
        JPanel illustrationPanel = new JPanel();
        JPanel illustrationLabelsPanel = new JPanel();
        JPanel radioButtonPanel = new JPanel();
        illustrationLabelsPanel.setLayout(new BoxLayout(illustrationLabelsPanel, 1));
        illustrationPanel.add(smoothTransitionIllustration);
        illustrationLabelsPanel.add(velocityLabel);
        illustrationLabelsPanel.add(timeLabel);
        illustrationLabelsPanel.add(Box.createVerticalStrut(25));
        illustrationLabelsPanel.add(hardTransitionLabel);
        illustrationLabelsPanel.add(softTransitionLabel);
        illustrationPanel.add(illustrationLabelsPanel);
        radioButtonPanel.add(this.hardTransitionRadioButton);
        radioButtonPanel.add(Box.createHorizontalStrut(80));
        radioButtonPanel.add(this.softTransitionRadioButton);
        JPanel jPanel = this.viewContext.createFormBuilder().description(HTML.html((String)textResource.smoothTransitionDescription()), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(2).description(HTML.html((String)textResource.smoothTransitionAffectedDescription()), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(2).description(ViewImageResource.formInformation(), HTML.html((String)textResource.smoothTransitionInfoSafetyDescription()), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS, FormBuilder.PanelConstraints.SPAN_1_ROW}).end(1).description(HTML.html((String)textResource.smoothTransitionSafetySystemDescriptionG5()), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS, FormBuilder.PanelConstraints.SPAN_1_ROW}).end(3).component((JComponent)illustrationPanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS, FormBuilder.PanelConstraints.SPAN_8_ROWS}).end(2).component((JComponent)radioButtonPanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(2).getCardPanel(textResource.smoothTransitionTitle());
        this.add(jPanel, "Center");
    }

    private void initHelpIds() {
        this.helpIdAssigner.assignHelpId((JComponent)((Object)this), "gui:installation_smooth_transition");
    }

    @Override
    protected void updateCard(SmoothTransitionSettings settings) {
        this.radioButtons.clearSelection();
        switch (settings.getTransitionHardness()) {
            case HARD: {
                this.hardTransitionRadioButton.setSelected(true);
                break;
            }
            case SOFT: {
                this.softTransitionRadioButton.setSelected(true);
                break;
            }
            default: {
                Log.error((String)("Unknown enum " + (Object)((Object)settings.getTransitionHardness())));
            }
        }
    }

    private void setTransitionHardness(SmoothTransitionSettings.TransitionHardness transitionHardness) {
        SmoothTransitionSettings s = (SmoothTransitionSettings)this.getInstallationComponent();
        s.setTransitionHardness(transitionHardness);
        this.sendToController(s);
        this.fireTransitionHardnessChanged();
    }

    private void sendToController(SmoothTransitionSettings settings) {
        SmoothTransitionSendToController send = new SmoothTransitionSendToController(this.controllerInterface);
        send.setSmoothTransition(settings);
    }

    private void fireTransitionHardnessChanged() {
        EventNotificationService.notify(InstallationStateListener.class, (NotificationStrategy)new NotificationStrategy<InstallationStateListener>(){

            public void notify(InstallationStateListener listener) {
                listener.installationModified();
            }
        });
    }

    private class HardTransitionAction
    extends AbstractActionDefinition {
        public HardTransitionAction(TextResource text) {
            this.putValue("Name", text.smoothTransitionHardTransition());
        }

        public void actionPerformed(ActionEvent e) {
            SmoothTransitionPanel.this.setTransitionHardness(SmoothTransitionSettings.TransitionHardness.HARD);
        }
    }

    private class SoftTransitionAction
    extends AbstractActionDefinition {
        public SoftTransitionAction(TextResource text) {
            this.putValue("Name", text.smoothTransitionSoftTransition());
        }

        public void actionPerformed(ActionEvent e) {
            SmoothTransitionPanel.this.setTransitionHardness(SmoothTransitionSettings.TransitionHardness.SOFT);
        }
    }
}

