/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.polyscope.persistence.installation.toolwrench;

import com.ur.polyscope.installation.InstallationChangedEvent;
import com.ur.polyscope.installation.InstallationComponent;
import com.ur.polyscope.installation.aspect.InstallationChangeEventAspect;
import com.ur.polyscope.scriptwriter.PreambleScript;
import com.ur.polyscope.scriptwriter.ScriptGeneratorLookup;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.view.polyscope.persistence.installation.toolwrench.ToolWrenchConfiguration$AjcClosure1;
import com.ur.view.polyscope.persistence.installation.toolwrench.ToolWrenchConfiguration$AjcClosure3;
import com.ur.view.polyscope.persistence.installation.toolwrench.ToolWrenchConfiguration$AjcClosure5;
import com.ur.view.polyscope.persistence.installation.toolwrench.ToolWrenchConfiguration$AjcClosure7;
import java.text.MessageFormat;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class ToolWrenchConfiguration
implements InstallationComponent,
PreambleScript {
    static final double DEFAULT_FORCE_LIMIT = 6.0;
    static final double DEFAULT_MOMENT_LIMIT = 0.3;
    private double toolWrenchForceLimit = 6.0;
    private double toolWrenchMomentLimit = 0.3;
    private boolean toolWrenchForceLimitEnabled = false;
    private boolean toolWrenchMomentLimitEnabled = false;
    private final String TOOL_WRENCH_LIMIT_SET_COMMAND = "tool_wrench_limit_set({0})";
    private final String TOOL_WRENCH_LIMIT_DISABLE_COMMAND = "tool_wrench_limit_disable()";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public Class<?> getType() {
        return ToolWrenchConfiguration.class;
    }

    public boolean canGenerateScriptCode() {
        return true;
    }

    public void generatePreambleScript(ScriptWriter scriptWriter, ScriptGeneratorLookup scriptGeneratorLookup) {
        if (this.toolWrenchForceLimitEnabled || this.toolWrenchMomentLimitEnabled) {
            String command = MessageFormat.format("tool_wrench_limit_set({0})", this.getToolWrenchLimitSetParameters());
            scriptWriter.appendLine(command);
        } else {
            scriptWriter.appendLine("tool_wrench_limit_disable()");
        }
    }

    @InstallationChangedEvent
    public void setToolWrenchForceLimit(double forceLimit) {
        double d = forceLimit;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)Conversions.doubleObject((double)d));
        Object[] objectArray = new Object[]{this, Conversions.doubleObject((double)d), joinPoint};
        ToolWrenchConfiguration$AjcClosure1 toolWrenchConfiguration$AjcClosure1 = new ToolWrenchConfiguration$AjcClosure1(objectArray);
        InstallationChangeEventAspect.aspectOf().aroundAnnotatedMethod(toolWrenchConfiguration$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @InstallationChangedEvent
    public void setToolWrenchMomentLimit(double momentLimit) {
        double d = momentLimit;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)Conversions.doubleObject((double)d));
        Object[] objectArray = new Object[]{this, Conversions.doubleObject((double)d), joinPoint};
        ToolWrenchConfiguration$AjcClosure3 toolWrenchConfiguration$AjcClosure3 = new ToolWrenchConfiguration$AjcClosure3(objectArray);
        InstallationChangeEventAspect.aspectOf().aroundAnnotatedMethod(toolWrenchConfiguration$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    public double getToolWrenchForceLimit() {
        return this.toolWrenchForceLimit;
    }

    public double getToolWrenchMomentLimit() {
        return this.toolWrenchMomentLimit;
    }

    public boolean isToolWrenchForceLimitEnabled() {
        return this.toolWrenchForceLimitEnabled;
    }

    @InstallationChangedEvent
    public void setToolWrenchForceLimitEnabled(boolean toolWrenchForceLimitEnabled) {
        boolean bl = toolWrenchForceLimitEnabled;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, Conversions.booleanObject((boolean)bl), joinPoint};
        ToolWrenchConfiguration$AjcClosure5 toolWrenchConfiguration$AjcClosure5 = new ToolWrenchConfiguration$AjcClosure5(objectArray);
        InstallationChangeEventAspect.aspectOf().aroundAnnotatedMethod(toolWrenchConfiguration$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    public boolean isToolWrenchMomentLimitEnabled() {
        return this.toolWrenchMomentLimitEnabled;
    }

    @InstallationChangedEvent
    public void setToolWrenchMomentLimitEnabled(boolean toolWrenchMomentLimitEnabled) {
        boolean bl = toolWrenchMomentLimitEnabled;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, Conversions.booleanObject((boolean)bl), joinPoint};
        ToolWrenchConfiguration$AjcClosure7 toolWrenchConfiguration$AjcClosure7 = new ToolWrenchConfiguration$AjcClosure7(objectArray);
        InstallationChangeEventAspect.aspectOf().aroundAnnotatedMethod(toolWrenchConfiguration$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    private String getToolWrenchLimitSetParameters() {
        StringBuilder parameters = new StringBuilder();
        parameters.append("p[0,0,0,0,0,0]");
        if (this.toolWrenchForceLimitEnabled) {
            parameters.append(",").append("Fx=").append(this.toolWrenchForceLimit);
            parameters.append(",").append("Fy=").append(this.toolWrenchForceLimit);
            parameters.append(",").append("Fz=").append(this.toolWrenchForceLimit);
        }
        if (this.toolWrenchMomentLimitEnabled) {
            parameters.append(",").append("Mx=").append(this.toolWrenchMomentLimit);
            parameters.append(",").append("My=").append(this.toolWrenchMomentLimit);
            parameters.append(",").append("Mz=").append(this.toolWrenchMomentLimit);
        }
        return parameters.toString();
    }

    static {
        ToolWrenchConfiguration.ajc$preClinit();
    }

    static final /* synthetic */ void setToolWrenchForceLimit_aroundBody0(ToolWrenchConfiguration ajc$this, double forceLimit, JoinPoint joinPoint) {
        ajc$this.toolWrenchForceLimit = forceLimit;
    }

    static final /* synthetic */ void setToolWrenchMomentLimit_aroundBody2(ToolWrenchConfiguration ajc$this, double momentLimit, JoinPoint joinPoint) {
        ajc$this.toolWrenchMomentLimit = momentLimit;
    }

    static final /* synthetic */ void setToolWrenchForceLimitEnabled_aroundBody4(ToolWrenchConfiguration ajc$this, boolean toolWrenchForceLimitEnabled, JoinPoint joinPoint) {
        ajc$this.toolWrenchForceLimitEnabled = toolWrenchForceLimitEnabled;
    }

    static final /* synthetic */ void setToolWrenchMomentLimitEnabled_aroundBody6(ToolWrenchConfiguration ajc$this, boolean toolWrenchMomentLimitEnabled, JoinPoint joinPoint) {
        ajc$this.toolWrenchMomentLimitEnabled = toolWrenchMomentLimitEnabled;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ToolWrenchConfiguration.java", ToolWrenchConfiguration.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setToolWrenchForceLimit", "com.ur.view.polyscope.persistence.installation.toolwrench.ToolWrenchConfiguration", "double", "forceLimit", "", "void"), 44);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setToolWrenchMomentLimit", "com.ur.view.polyscope.persistence.installation.toolwrench.ToolWrenchConfiguration", "double", "momentLimit", "", "void"), 49);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setToolWrenchForceLimitEnabled", "com.ur.view.polyscope.persistence.installation.toolwrench.ToolWrenchConfiguration", "boolean", "toolWrenchForceLimitEnabled", "", "void"), 66);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setToolWrenchMomentLimitEnabled", "com.ur.view.polyscope.persistence.installation.toolwrench.ToolWrenchConfiguration", "boolean", "toolWrenchMomentLimitEnabled", "", "void"), 75);
    }
}

