/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.polyscope.persistence.installation.toolwrench;

import com.ur.polyscope.installation.InstallationComponentConversionStrategy;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.view.polyscope.persistence.installation.toolwrench.ToolWrenchConfiguration;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;

public class ToolWrenchConversionStrategy
extends ConversionStrategyTemplate<ToolWrenchConfiguration>
implements InstallationComponentConversionStrategy<ToolWrenchConfiguration> {
    private final Provider<ToolWrenchConfiguration> provider;
    private static final String FORCE_LIMIT = "forceLimit";
    private static final String FORCE_LIMIT_ENABLED = "forceLimitEnabled";
    private static final String MOMENT_LIMIT = "momentLimit";
    private static final String MOMENT_LIMIT_ENABLED = "momentLimitEnabled";

    @Inject
    public ToolWrenchConversionStrategy(Provider<ToolWrenchConfiguration> provider) {
        super(ToolWrenchConfiguration.class);
        this.provider = provider;
    }

    public void marshal(ToolWrenchConfiguration toolWrenchConfiguration, PersistWriter persistWriter) {
        persistWriter.addAttribute(FORCE_LIMIT, toolWrenchConfiguration.getToolWrenchForceLimit());
        persistWriter.addAttribute(FORCE_LIMIT_ENABLED, toolWrenchConfiguration.isToolWrenchForceLimitEnabled());
        persistWriter.addAttribute(MOMENT_LIMIT, toolWrenchConfiguration.getToolWrenchMomentLimit());
        persistWriter.addAttribute(MOMENT_LIMIT_ENABLED, toolWrenchConfiguration.isToolWrenchMomentLimitEnabled());
    }

    public ToolWrenchConfiguration unmarshal(PersistReader reader) {
        ToolWrenchConfiguration settings = (ToolWrenchConfiguration)this.provider.get();
        settings.setToolWrenchForceLimitEnabled(reader.getBooleanAttribute(FORCE_LIMIT_ENABLED, false));
        settings.setToolWrenchMomentLimitEnabled(reader.getBooleanAttribute(MOMENT_LIMIT_ENABLED, false));
        settings.setToolWrenchForceLimit(reader.getDoubleAttribute(FORCE_LIMIT, 6.0));
        settings.setToolWrenchMomentLimit(reader.getDoubleAttribute(MOMENT_LIMIT, 0.3));
        return settings;
    }

    public Map<String, Class<? extends ToolWrenchConfiguration>> getClassAliases(boolean forMarshalling) {
        return Collections.singletonMap("ToolWrenchConfiguration", ToolWrenchConfiguration.class);
    }

    public Map<String, Class<? extends ToolWrenchConfiguration>> getTypeAliases(boolean forMarshalling) {
        return Collections.singletonMap("ToolWrenchConfiguration", ToolWrenchConfiguration.class);
    }
}

