/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.polyscope.persistence.installation.toolwrench;

import com.ur.i18n.TextResource;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.resources.IllustrationImageResource;
import com.ur.resources.ViewImageResource;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.number.NumberField;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.swing.HTML;
import com.ur.view.polyscope.persistence.installation.smoothtransition.InstallationComponentCardPanel;
import com.ur.view.polyscope.persistence.installation.toolwrench.ToolWrenchConfiguration;
import java.awt.BorderLayout;
import javax.inject.Inject;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ToolWrenchPanel
extends InstallationComponentCardPanel<ToolWrenchConfiguration> {
    public static final String SHOW_TOOL_WRENCH_ACTION = "showToolWrench.G5ToolWrenchPanel";
    public static final String FORCE_LIMIT_CHECKBOX = "forceLimitCheckbox." + ToolWrenchPanel.class.getSimpleName();
    public static final String TORQUE_LIMIT_CHECKBOX = "torqueLimitCheckbox." + ToolWrenchPanel.class.getSimpleName();
    private final ViewContext viewContext;
    private ToolWrenchConfiguration toolWrenchConfiguration;
    private static final double FORCE_VALIDATOR_MINIMUM = 0.1;
    private static final double MOMENT_VALIDATOR_MINIMUM = 0.01;
    private static final int FORCE_UPPER_LIMIT = 400;
    private static final int MOMENT_UPPER_LIMIT = 100;
    private NumberField limitAccForceOnPayloadTextField;
    private NumberField limitAccMomentOnPayloadTextField;
    private JCheckBox limitAccForceOnPayloadCheckBox;
    private JCheckBox limitAccMomentOnPayloadCheckBox;

    @Inject
    public ToolWrenchPanel(InstallationComponentLookup lookupService, ViewContext viewContext) {
        super(lookupService, viewContext, ToolWrenchConfiguration.class);
        this.viewContext = viewContext;
        this.toolWrenchConfiguration = (ToolWrenchConfiguration)this.getInstallationComponent();
        this.initComponents();
    }

    private void initComponents() {
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        WidgetFactory widgetFactory = this.viewContext.createWidgetFactory();
        this.setLayout(new BorderLayout(5, 5));
        this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        this.initToolWrenchForceLimitFields(textResource);
        this.initToolWrenchMomentLimitFields(textResource);
        this.initToolWrenchForceLimitCheckbox(widgetFactory, textResource);
        this.initToolWrenchMomentLimitCheckbox(widgetFactory, textResource);
        JLabel toolWrenchIllustration = widgetFactory.createLabel(IllustrationImageResource.toolWrench());
        JPanel illustrationPanel = new JPanel();
        illustrationPanel.add(toolWrenchIllustration);
        JPanel illustrationLabelPanel = new JPanel();
        illustrationLabelPanel.setLayout(new BoxLayout(illustrationLabelPanel, 1));
        illustrationPanel.add(illustrationLabelPanel);
        String benefitBulletList = HTML.html((String)("\u2022 " + textResource.toolWrenchLimitBenefitBullet1() + "<br/>" + "\u2022 " + textResource.toolWrenchLimitBenefitBullet2()));
        JPanel content = this.viewContext.createFormBuilder().description(textResource.toolWrenchLimitDescription(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS, FormBuilder.PanelConstraints.SPAN_1_ROW}).end(1).description(benefitBulletList, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(1).description(ViewImageResource.formInformation(), textResource.toolWrenchLimitImpact(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(1).component((JComponent)this.limitAccForceOnPayloadCheckBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN, FormBuilder.PanelConstraints.SPAN_1_ROW}).component((JComponent)this.limitAccForceOnPayloadTextField, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN, FormBuilder.PanelConstraints.SPAN_1_ROW}).spacer(1).end(1).component((JComponent)this.limitAccMomentOnPayloadCheckBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN, FormBuilder.PanelConstraints.SPAN_1_ROW}).component((JComponent)this.limitAccMomentOnPayloadTextField, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN, FormBuilder.PanelConstraints.SPAN_1_ROW}).spacer(1).end(1).component((JComponent)illustrationPanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS, FormBuilder.PanelConstraints.SPAN_10_ROWS}).end(1).getCardPanel(textResource.toolWrenchLimitHeader());
        this.add(content, "Center");
    }

    private void initToolWrenchMomentLimitCheckbox(WidgetFactory widgetFactory, TextResource textResource) {
        this.limitAccMomentOnPayloadCheckBox = widgetFactory.createCheckBox(HTML.html((String)textResource.limitAccMomentOnPayload("<b>(M)</b>")));
        this.limitAccMomentOnPayloadCheckBox.setName(TORQUE_LIMIT_CHECKBOX);
        this.limitAccMomentOnPayloadCheckBox.setSelected(this.toolWrenchConfiguration.isToolWrenchMomentLimitEnabled());
        this.limitAccMomentOnPayloadCheckBox.addActionListener(e -> {
            boolean isSelected = this.limitAccMomentOnPayloadCheckBox.isSelected();
            this.limitAccMomentOnPayloadTextField.setEnabled(isSelected);
            ToolWrenchConfiguration configuration = (ToolWrenchConfiguration)this.getInstallationComponent();
            configuration.setToolWrenchMomentLimitEnabled(isSelected);
        });
    }

    private void initToolWrenchForceLimitCheckbox(WidgetFactory widgetFactory, TextResource textResource) {
        this.limitAccForceOnPayloadCheckBox = widgetFactory.createCheckBox(HTML.html((String)textResource.limitAccForceOnPayload("<b>(F)</b>")));
        this.limitAccForceOnPayloadCheckBox.setName(FORCE_LIMIT_CHECKBOX);
        this.limitAccForceOnPayloadCheckBox.setSelected(this.toolWrenchConfiguration.isToolWrenchForceLimitEnabled());
        this.limitAccForceOnPayloadCheckBox.addActionListener(e -> {
            boolean isSelected = this.limitAccForceOnPayloadCheckBox.isSelected();
            this.limitAccForceOnPayloadTextField.setEnabled(isSelected);
            ToolWrenchConfiguration configuration = (ToolWrenchConfiguration)this.getInstallationComponent();
            configuration.setToolWrenchForceLimitEnabled(isSelected);
        });
    }

    private void initToolWrenchForceLimitFields(TextResource textResource) {
        this.limitAccForceOnPayloadTextField = new NumberField();
        this.limitAccForceOnPayloadTextField.setUnitWidth(55);
        this.limitAccForceOnPayloadTextField.setUnit("N");
        this.limitAccForceOnPayloadTextField.setValue((Object)this.toolWrenchConfiguration.getToolWrenchForceLimit());
        this.limitAccForceOnPayloadTextField.setEnabled(false);
        this.limitAccForceOnPayloadTextField.setNumberFieldWidth(300, 50);
        ValidationStrategy forceRangeValidator = ValidationFactory.getRangeValidator((double)0.1, (double)400.0, (String)textResource.toolWrenchValidationError(0.1, 400.0));
        this.limitAccForceOnPayloadTextField.setErrorValidationStrategy(new ValidationStrategy[]{forceRangeValidator});
        this.limitAccForceOnPayloadTextField.addActionListener(actionEvent -> this.toolWrenchConfiguration.setToolWrenchForceLimit((Double)this.limitAccForceOnPayloadTextField.getValue()));
    }

    private void initToolWrenchMomentLimitFields(TextResource textResource) {
        this.limitAccMomentOnPayloadTextField = new NumberField();
        this.limitAccMomentOnPayloadTextField.setUnitWidth(55);
        this.limitAccMomentOnPayloadTextField.setUnit("Nm");
        this.limitAccMomentOnPayloadTextField.setValue((Object)this.toolWrenchConfiguration.getToolWrenchMomentLimit());
        this.limitAccMomentOnPayloadTextField.setEnabled(false);
        this.limitAccMomentOnPayloadTextField.setNumberFieldWidth(300, 50);
        ValidationStrategy momentRangeValidator = ValidationFactory.getRangeValidator((double)0.01, (double)100.0, (String)textResource.toolWrenchValidationError(0.01, 100.0));
        this.limitAccMomentOnPayloadTextField.setErrorValidationStrategy(new ValidationStrategy[]{momentRangeValidator});
        this.limitAccMomentOnPayloadTextField.addActionListener(actionEvent -> this.toolWrenchConfiguration.setToolWrenchMomentLimit((Double)this.limitAccMomentOnPayloadTextField.getValue()));
    }

    @Override
    protected void updateCard(ToolWrenchConfiguration configuration) {
        this.toolWrenchConfiguration = configuration;
        boolean isForceLimitCheckboxEnabled = configuration.isToolWrenchForceLimitEnabled();
        this.limitAccForceOnPayloadCheckBox.setSelected(isForceLimitCheckboxEnabled);
        this.limitAccForceOnPayloadTextField.setValue((Object)configuration.getToolWrenchForceLimit());
        this.limitAccForceOnPayloadTextField.setEnabled(isForceLimitCheckboxEnabled);
        boolean isMomentLimitCheckboxEnabled = configuration.isToolWrenchMomentLimitEnabled();
        this.limitAccMomentOnPayloadCheckBox.setSelected(isMomentLimitCheckboxEnabled);
        this.limitAccMomentOnPayloadTextField.setValue((Object)configuration.getToolWrenchMomentLimit());
        this.limitAccMomentOnPayloadTextField.setEnabled(isMomentLimitCheckboxEnabled);
    }
}

