/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.polyscope.persistence.installation.variables;

import com.ur.i18n.TextResource;
import com.ur.polyscope.persistence.ConversionStrategy;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.view.variables.core.InstallationVariable;
import com.ur.view.variables.domain.InstallationVariables;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class InstallationVariablesConversionStrategy
implements ConversionStrategy<InstallationVariables> {
    public static final String INSTALLATION_VARIABLE = "InstallationVariables";
    public static final String NAME = "name";
    public static final String VARIABLE = "variable";
    public static final String VALUE = "value";
    public static final String DESCRIPTION = "description";
    public static final String IS_FAVOURITE = "favourite";
    public static final String TIMESTAMP = "timestamp";
    public final TextResource textResource;

    public InstallationVariablesConversionStrategy(TextResource textResource) {
        this.textResource = textResource;
    }

    public Class<InstallationVariables> getSupportedType() {
        return InstallationVariables.class;
    }

    public boolean canUnmarshalFrom(PersistReader persistReader) {
        return true;
    }

    public void marshal(InstallationVariables installationVariables, PersistWriter writer) {
        this.addTimeStamp(writer);
        Collection<InstallationVariable> installationVariablesList = installationVariables.getInstallationVariables();
        for (InstallationVariable variable : installationVariablesList) {
            writer.startNode(VARIABLE);
            writer.addAttribute(NAME, variable.getName());
            writer.addAttribute(VALUE, variable.getValue());
            writer.addAttribute(IS_FAVOURITE, variable.isFavourite());
            if (!StringUtils.isEmpty((String)variable.getDescription())) {
                writer.addAttribute(DESCRIPTION, variable.getDescription());
            }
            writer.endNode();
        }
    }

    public InstallationVariables unmarshal(PersistReader reader) {
        InstallationVariables installationVariables = new InstallationVariables(this.textResource);
        ValidationStrategy expressionResolution = ValidationFactory.getExpressionValueValidator();
        if (reader.hasMoreNodes()) {
            while (reader.hasMoreNodes()) {
                reader.moveToChildNode();
                String name = reader.getStringAttribute(NAME);
                String value = reader.getStringAttribute(VALUE);
                String description = reader.getStringAttribute(DESCRIPTION);
                boolean isFavourite = reader.getBooleanAttribute(IS_FAVOURITE);
                if (!expressionResolution.isValid(value)) {
                    value = "\"\"";
                }
                InstallationVariable variable = installationVariables.addInstallationVariable(name, value);
                variable.setDescription(description);
                variable.setIsFavourite(isFavourite);
                reader.moveToParentNode();
            }
        }
        installationVariables.clearModifiedState();
        return installationVariables;
    }

    public Map<String, Class<? extends InstallationVariables>> getClassAliases(boolean forMarshalling) {
        LinkedHashMap<String, Class<? extends InstallationVariables>> aliasMap = new LinkedHashMap<String, Class<? extends InstallationVariables>>();
        aliasMap.put(INSTALLATION_VARIABLE, InstallationVariables.class);
        return aliasMap;
    }

    public Map<String, Class<? extends InstallationVariables>> getTypeAliases(boolean forMarshalling) {
        HashMap<String, Class<? extends InstallationVariables>> aliasMap = new HashMap<String, Class<? extends InstallationVariables>>();
        aliasMap.put(INSTALLATION_VARIABLE, InstallationVariables.class);
        return aliasMap;
    }

    private void addTimeStamp(PersistWriter writer) {
        Date dateFromInstant = Date.from(Instant.now());
        writer.addAttribute(TIMESTAMP, dateFromInstant.toString());
    }
}

