/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.polyscope.persistence.program;

import com.ur.util.logging.Log;
import java.util.concurrent.ConcurrentHashMap;

public class LogTime {
    private static final ConcurrentHashMap<String, Long> startTimes = new ConcurrentHashMap();

    private LogTime() {
    }

    public static void startLog(String name) {
        if (startTimes.containsKey(name)) {
            Log.warning((String)("Name [" + name + "] has already been registered."));
        } else {
            startTimes.put(name, System.currentTimeMillis());
        }
    }

    public static void stopLog(String name, long minElapsedTime) {
        LogTime.stopLog(name, "", minElapsedTime);
    }

    public static void stopLog(String name, String suffix, long minElapsedTime) {
        if (startTimes.containsKey(name)) {
            LogTime.removeEntryAndLog(name, suffix, minElapsedTime);
        } else {
            Log.warning((String)("Name [" + name + "] has not been registered."));
        }
    }

    private static void removeEntryAndLog(String name, String suffix, long minElapsedTime) {
        Long startTime = startTimes.remove(name);
        if (startTime != null) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            if (minElapsedTime < 1L) {
                Log.debug((String)(String.valueOf(name) + " " + suffix + "\n\tTotal elapsed time: " + elapsedTime + "ms."));
            } else if (elapsedTime > minElapsedTime) {
                Log.warning((String)(String.valueOf(name) + " " + suffix + "\n\tTotal elapsed time: " + elapsedTime + "ms."));
            }
        }
    }
}

