/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.polyscope.persistence.program;

import com.ur.i18n.TextResource;
import com.ur.polyscope.driver.api.dialog.DialogWithName;
import com.ur.polyscope.filemanager.FileContainer;
import com.ur.polyscope.filemanager.FileManagerConfiguration;
import com.ur.polyscope.filemanager.FileTypePersistence;
import com.ur.polyscope.filemanager.PerformingFileContainer;
import com.ur.polyscope.program.ProgramModeHolder;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.dialog.DialogReturnValue;
import com.ur.swing.dialog.YesNoCancelDialogListener;
import com.ur.util.logging.Log;
import com.ur.view.program.filemanager.ProgramFileManagerConfiguration;
import gui.installation.services.ProgramLookupService;
import gui.polyscope.DashBoard;
import gui.polyscope.SaveProgramService;
import gui.program.FileManagementProgramComponent;
import gui.program.ProgramRootNode;
import gui.program.ProgramRootNodeLoad;
import gui.program.ProgramRootNodeSave;
import gui.tools.DialogCreator;
import gui.tools.LanguagePack;
import gui.tools.LegacyURDialogCreator;
import gui.tools.URFileUtils;
import java.io.File;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ProgramRootNodePersistence {
    private static final PerformingFileContainer NULL_INSTANCE = new PerformingFileContainer();
    public static final Runnable EMPTY_ACTION = new Runnable(){

        @Override
        public void run() {
        }
    };
    private PerformingFileContainer saveFileContainer = NULL_INSTANCE;
    private final DialogCreator dialogCreator;
    private final ProgramLookupService programLookupService;
    private final SaveProgramService saveProgramService;
    private ProgramRootNodeSave programRootNodeSave;
    private FileTypePersistence fileTypePersistence;
    private final TextResource textResource;

    @Inject
    public ProgramRootNodePersistence(DialogCreator dialogCreator, ProgramLookupService programLookupService, SaveProgramService saveProgramService, ProgramRootNodeSave programRootNodeSave, FileTypePersistence fileTypePersistence, TextResource textResource) {
        this.dialogCreator = dialogCreator;
        this.programLookupService = programLookupService;
        this.saveProgramService = saveProgramService;
        this.programRootNodeSave = programRootNodeSave;
        this.fileTypePersistence = fileTypePersistence;
        this.textResource = textResource;
    }

    public void requestToSaveUnsavedProgramChanges(Runnable continueAction) {
        ProgramRootNode program = this.programLookupService.getProgramRootNode();
        this.requestToSaveUnsavedProgramChanges(program, continueAction);
    }

    public void save(Runnable continueAction) {
        ProgramRootNode program = this.programLookupService.getProgramRootNode();
        this.save(program, continueAction);
    }

    private void save(ProgramRootNode program, Runnable continueAction) {
        if (!program.hasBeenSaved()) {
            this.saveProgramAsAndRunAction(program, continueAction);
        } else {
            this.programRootNodeSave.save(program);
            continueAction.run();
        }
    }

    public void saveAs(Runnable continueAction) {
        ProgramRootNode program = this.programLookupService.getProgramRootNode();
        this.saveProgramAsAndRunAction(program, continueAction);
    }

    private void requestToSaveUnsavedProgramChanges(final ProgramRootNode program, final Runnable continueAction) {
        if (program == null || !this.saveProgramService.hasChanges()) {
            continueAction.run();
            return;
        }
        YesNoCancelDialogListener saveListener = new YesNoCancelDialogListener(){

            public void onYesClicked() {
                ProgramRootNodePersistence.this.save(program, continueAction);
            }

            public void onNoClicked() {
                continueAction.run();
            }
        };
        this.dialogCreator.showSaveProgramChangesDialog(program.getName(), saveListener);
    }

    private void saveProgramAsAndRunAction(ProgramRootNode program, Runnable continueAction) {
        if (program != null) {
            this.saveFileContainer = new SaveFileAndRunActionContainer(this.programRootNodeSave, program, continueAction, this.textResource);
            if (program.getName() != null) {
                this.saveFileContainer.setFile(program.getComponent(FileManagementProgramComponent.class).getFile(program));
            }
            this.fileTypePersistence.saveFile((FileContainer)this.saveFileContainer, (FileManagerConfiguration)new ProgramFileManagerConfiguration(this.textResource.saveProgram()), ".urp");
        }
    }

    public static void performAdvancedLoadProgram(TextResource textResource, FileTypePersistence filePersistence, ProgramModeHolder programModeHolder) {
        LoadFileContainer container = new LoadFileContainer();
        ProgramRootNode program = DashBoard.getProgram();
        container.setFile(program == null ? null : program.getComponent(FileManagementProgramComponent.class).getFile(program));
        filePersistence.openFile((FileContainer)container, (FileManagerConfiguration)new ProgramFileManagerConfiguration(textResource.loadProgram(), programModeHolder));
    }

    private static class LoadFileContainer
    extends PerformingFileContainer {
        private LoadFileContainer() {
        }

        public boolean perform() {
            try {
                if (this.hasFileSelected()) {
                    Log.debug((String)("PolyscopePanel.loadProgram(): file = " + this.getFile()));
                    ProgramRootNode p = ProgramRootNodeLoad.load(this.getFile());
                    if (p == null) {
                        Log.error((String)"PolyscopePanel.loadProgram(): loaded program is null");
                        return false;
                    }
                    return true;
                }
                return false;
            }
            finally {
                this.setFile(null);
            }
        }
    }

    private static class SaveFileAndRunActionContainer
    extends SaveFileContainer {
        private Runnable continueRunnable;

        public SaveFileAndRunActionContainer(ProgramRootNodeSave programRootNodeSave, ProgramRootNode programRootNode, Runnable continueRunnable, TextResource textResource) {
            super(programRootNodeSave, programRootNode, textResource);
            this.continueRunnable = continueRunnable;
        }

        @Override
        public boolean perform() {
            boolean performedOK = super.perform();
            if (performedOK) {
                this.continueRunnable.run();
            }
            return performedOK;
        }
    }

    private static class SaveFileContainer
    extends PerformingFileContainer {
        private final ProgramRootNodeSave programRootNodeSave;
        private final ProgramRootNode prn;
        private TextResource textResource;

        public SaveFileContainer(ProgramRootNodeSave programRootNodeSave, ProgramRootNode n, TextResource textResource) {
            this.programRootNodeSave = programRootNodeSave;
            this.prn = n;
            this.textResource = textResource;
        }

        public boolean perform() {
            try {
                if (this.hasFileSelected()) {
                    if (URFileUtils.isFilenameValid(this.getFile())) {
                        boolean bl = this.saveProgram();
                        return bl;
                    }
                    String path = this.getFile().getPath().replaceAll(String.valueOf(System.getenv("HOME")) + File.separator + "programs", "");
                    Log.error((String)("Could not save program file: \"" + path));
                    LegacyURDialogCreator.showErrorDialog(LanguagePack.getErrorMessages().unableToSaveProgram(path));
                    return false;
                }
                return false;
            }
            finally {
                this.setFile(null);
            }
        }

        private boolean saveProgram() {
            if (this.programRootNodeSave.isInstallationModified() || this.programRootNodeSave.isSavingExternally(this.prn, this.getFile())) {
                if (this.isInstallationBeingOverwritten()) {
                    if (this.confirm()) {
                        this.save();
                        return true;
                    }
                    return false;
                }
                this.save();
                return true;
            }
            this.save();
            return true;
        }

        protected boolean confirm() {
            ConfirmationMessage message = new ConfirmationMessage(DialogWithName.CONFIRM_OVERWRITE.getName(), this.textResource.confirmOverwriteFileTitle(), this.textResource.confirmOverwriteFileExplanation(String.valueOf(this.prn.getComponent(FileManagementProgramComponent.class).getInstallationFileName()) + ".installation"), this.textResource.confirmOverwriteFileAction(), this.textResource.Cancel());
            return LegacyURDialogCreator.confirmMessageDialog(message) == DialogReturnValue.OK;
        }

        private boolean isInstallationBeingOverwritten() {
            return this.getFile() != null && this.programRootNodeSave.isInstallationBeingCopied(this.getFile().getParentFile().getPath()) && new File(this.getFile().getParentFile().getPath(), String.valueOf(this.prn.getComponent(FileManagementProgramComponent.class).getInstallationFileName()) + ".installation").exists();
        }

        private void save() {
            this.programRootNodeSave.saveToFile(this.prn, this.getFile());
        }
    }
}

