/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.program;

import com.ur.i18n.TextResource;
import com.ur.log.logentry.robotmessage.RobotMessageProducer;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.util.event.EventManager;
import com.ur.view.program.PlayProgramListener;
import gui.polyscope.SaveProgramService;
import gui.program.FileManagementProgramComponent;
import gui.program.ProgramRootNode;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.inject.Inject;

public class AddToLogPlayingProgram
implements PlayProgramListener {
    private SaveProgramService saveProgramService;
    private TextResource textResource;

    @Inject
    private AddToLogPlayingProgram(SaveProgramService saveProgramService, EventManager eventManager, TextResource textResource) {
        this.saveProgramService = saveProgramService;
        eventManager.addStrongListener(PlayProgramListener.class, (Object)this);
        this.textResource = textResource;
    }

    @Override
    public void preparingPlay(ProgramRootNode program) {
    }

    @Override
    public void playing(ProgramRootNode program, ScriptWriter writer) {
        String programPath = program != null ? this.getProgramPath(program) : this.textResource.placeholderUnnamed();
        Date lastSavedDate = this.saveProgramService.getLastSavedDate();
        String changeInfo = lastSavedDate != null ? String.valueOf(this.textResource.lastSaved()) + ": " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(lastSavedDate) : this.textResource.Unsaved();
        new RobotMessageProducer().generateAndNotify(this.textResource.startingProgramLogMessage(programPath, changeInfo));
    }

    private String getProgramPath(ProgramRootNode program) {
        String programPath;
        FileManagementProgramComponent component = program.getComponent(FileManagementProgramComponent.class);
        String dir = component.getProgramDirectory();
        int index = dir.indexOf("programs");
        if (index >= 0 && index + 9 <= dir.length()) {
            dir = dir.substring(index + 9);
            programPath = String.valueOf(dir) + File.separatorChar + program.getName();
        } else {
            programPath = program.getName();
        }
        return programPath;
    }
}

