/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.program;

import com.ur.i18n.TextResource;
import com.ur.lang.adt.Pair;
import com.ur.lang.react.Recipe;
import com.ur.monitor.RobotState;
import com.ur.monitor.Source;
import com.ur.monitor.model.JointPositionVector;
import com.ur.move.automove.AutoMoveActionResult;
import com.ur.move.automove.AutoMoveAndPlay;
import com.ur.move.automove.MoveRobotControllerRPC;
import com.ur.polyscope.controllerinterface.AdditionalInfo;
import com.ur.polyscope.program.ProgramStateHolder;
import com.ur.polyscope.program.monitor.ProgramState;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.move.PositionNodeType;
import com.ur.polyscope.program.nodes.move.Positional;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.viewfacade.program.ProgramActionResult;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.swing.taskprogress.TaskMonitor;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.util.Waiting;
import com.ur.util.concurrent.ParallelTask;
import com.ur.util.concurrent.Task;
import com.ur.util.event.EventNotificationService;
import com.ur.util.logging.Log;
import com.ur.view.installation.safety.SafetyLockFacade;
import com.ur.view.program.PlayProgramListener;
import com.ur.view.program.ProgramControlPreparePlay;
import com.ur.view.program.ProgramExecutor;
import com.ur.view.program.stepping.StepProgramService;
import gui.program.ProgramRootNode;
import gui.tools.LanguagePack;
import gui.tools.LegacyURDialogCreator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ProgramControl {
    private final AutoMoveAndPlay autoMoveAndPlay;
    private final ProgramStateHolder programStateHolder;
    private final Lock sendControllerCommandLock = new ReentrantLock();
    private final ProgramExecutor programExecutor;
    private TaskMonitor taskMonitor;
    private Recipe<AdditionalInfo> additionalInfoRecipe;
    private final ProgramControlPreparePlay programControlPreparePlay;
    private final StepProgramService stepProgramService;
    private final MoveRobotControllerRPC moveRobotControllerRPC;
    private final SafetyLockFacade safetyLockFacade;
    private TextResource textResource;

    @Inject
    public ProgramControl(ProgramExecutor programExecutor, TaskMonitor taskMonitor, AutoMoveAndPlay autoMoveAndPlay, ProgramStateHolder programStateHolder, @Source(value=AdditionalInfo.class) Recipe<AdditionalInfo> additionalInfoRecipe, TextResource textResource, ProgramControlPreparePlay programControlPreparePlay, StepProgramService stepProgramService, MoveRobotControllerRPC moveRobotControllerRPC, SafetyLockFacade safetyLockFacade) {
        this.programExecutor = programExecutor;
        this.taskMonitor = taskMonitor;
        this.autoMoveAndPlay = autoMoveAndPlay;
        this.programStateHolder = programStateHolder;
        this.additionalInfoRecipe = additionalInfoRecipe;
        this.textResource = textResource;
        this.stepProgramService = stepProgramService;
        this.programControlPreparePlay = programControlPreparePlay;
        this.moveRobotControllerRPC = moveRobotControllerRPC;
        this.safetyLockFacade = safetyLockFacade;
    }

    public ProgramState getProgramState() {
        return this.programStateHolder.getProgramState();
    }

    public void setProgramState(ProgramState programState) {
        this.programStateHolder.setProgramState(programState);
    }

    public boolean canStopProgram() {
        return this.programExecutor.isProgramRunning();
    }

    public ProgramActionResult canRunProgram(ProgramRootNode program) {
        if (program == null) {
            throw new MissingProgram();
        }
        if (program.isUndefined()) {
            throw new IncompleteProgram();
        }
        if (!this.programExecutor.canExecute()) {
            throw new DisconnectedFromController();
        }
        if (this.programExecutor.isProgramRunning() && !this.programExecutor.isInkognito()) {
            Log.warning((String)"Robot is running program");
            return ProgramActionResult.ALREADY_PLAYING_PROGRAM;
        }
        if (this.safetyLockFacade.isSafetyUnlocked()) {
            Log.warning((String)"URCap safety is unlocked");
            return ProgramActionResult.URCAP_SAFETY_IS_UNLOCKED;
        }
        return ProgramActionResult.SUCCESS;
    }

    public ProgramActionResult canPauseProgram(ProgramRootNode program) {
        if (program == null) {
            throw new MissingProgram();
        }
        if (!this.programExecutor.canExecute()) {
            throw new DisconnectedFromController();
        }
        return ProgramActionResult.SUCCESS;
    }

    public ProgramActionResult canStepProgram(ProgramRootNode program) {
        if (program == null) {
            throw new MissingProgram();
        }
        return this.stepProgramService.canStepProgram(program);
    }

    public ProgramActionResult stepProgram(ProgramRootNode program) {
        if (program == null) {
            throw new MissingProgram();
        }
        return this.stepProgramService.stepProgram(program);
    }

    public void rewindProgram(ProgramRootNode program) {
        if (this.canRunProgram(program) == ProgramActionResult.SUCCESS) {
            try {
                ProgramRootNode.get(program).getMainProgram().setSelected();
            }
            catch (Exception ex) {
                Log.error((String)"Could not call program.rewind()", (Throwable)ex);
            }
        }
    }

    public JointPositionVector getFirstAvailableJointPositionVector(ProgramRootNode programRootNode) {
        Pair<Integer, Positional> startPosition = this.determineStartingPositional(programRootNode);
        if (startPosition != null) {
            return ((Positional)startPosition.getSecond()).getActualJointPositionVector();
        }
        return new JointPositionVector();
    }

    protected Pair<Integer, Positional> determineStartingPositional(ProgramRootNode programRootNode) {
        Set posSet = null;
        if (programRootNode.hasBeforeStart()) {
            posSet = programRootNode.getBeforeStart().getThisOrNextPositionNodePair(Positional.class);
        }
        if (posSet == null || posSet.isEmpty()) {
            posSet = programRootNode.getStartingNode().getThisOrPreviousPositionNodePairsNoWrapAround(Positional.class);
        }
        if (posSet == null || posSet.isEmpty()) {
            posSet = programRootNode.getStartingNode().getThisOrNextPositionNodePair(Positional.class);
        }
        for (Pair pair : posSet) {
            Positional p = (Positional)pair.getSecond();
            if (p.getPositionNodeType() != PositionNodeType.FIXED || p.isUndefined()) continue;
            return pair;
        }
        return null;
    }

    public void autoMoveToStart(JointPositionVector startPosition, double automaticMoveEpsilon) {
        if (this.programExecutor.mustMoveToLocationOnRealRobot(startPosition, automaticMoveEpsilon)) {
            Log.debug((String)"Automove to start position");
            this.moveRobotControllerRPC.sendMoveJProgram(startPosition);
            Waiting.until((Waiting.ItHappens)this.robotIsMovedTo(startPosition, automaticMoveEpsilon), (int)60, (int)1, (TimeUnit)TimeUnit.SECONDS);
            Waiting.until((Waiting.ItHappens)new ProgramIsStopped(), (int)1, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    private Waiting.ItHappens robotIsMovedTo(JointPositionVector startPosition, double automaticMoveEpsilon) {
        return () -> RobotState.getLatestRobotState().jointPosition.epsilonEquals(startPosition, automaticMoveEpsilon);
    }

    public ProgramActionResult playProgram(ProgramRootNode program, double automaticMoveEpsilon) {
        ProgramActionResult result = this.mergeResult(this.canRunProgram(program), this.programControlPreparePlay.preparePlay(program));
        if (result != ProgramActionResult.SUCCESS) {
            return result;
        }
        if (this.getProgramState() == ProgramState.STOPPED) {
            return this.play_makeScriptCode(program, automaticMoveEpsilon);
        }
        if (this.getProgramState() == ProgramState.PAUSED) {
            return this.resumeProgram(program);
        }
        return ProgramActionResult.ALREADY_PLAYING_PROGRAM;
    }

    public ProgramActionResult stopProgram() {
        ProgramActionResult result = this.programExecutor.stopProgram() ? ProgramActionResult.SUCCESS : ProgramActionResult.EXECUTION_ERROR;
        Log.debug((String)("Stopping program: " + result));
        return result;
    }

    public ProgramActionResult pauseProgram(ProgramRootNode program) {
        ProgramActionResult result = this.canPauseProgram(program);
        if (result != ProgramActionResult.SUCCESS) {
            return result;
        }
        result = this.programExecutor.pauseProgram() ? ProgramActionResult.SUCCESS : ProgramActionResult.EXECUTION_ERROR;
        Log.info((String)("Pausing program: " + result));
        return result;
    }

    public ProgramActionResult resumeProgram(ProgramRootNode program) {
        ProgramActionResult result = this.mergeResult(this.canRunProgram(program), this.programControlPreparePlay.getRobotStateResult());
        if (result != ProgramActionResult.SUCCESS) {
            return result;
        }
        result = this.programExecutor.resumeProgram() ? ProgramActionResult.SUCCESS : ProgramActionResult.EXECUTION_ERROR;
        Log.info((String)("Resuming program: " + result));
        return result;
    }

    private ProgramActionResult play_makeScriptCode(ProgramRootNode program, double autoStartEpsilon) {
        AutoMoveActionResult result;
        Pair<Integer, Positional> startPosition = this.determineStartingPositional(program);
        JointPositionVector startJointPosition = startPosition != null ? ((Positional)startPosition.getSecond()).getActualJointPositionVector() : new JointPositionVector();
        String nodeTitle = this.buildNodeTitle(startPosition);
        if (this.programExecutor.mustMoveToLocationOnRealRobot(startJointPosition, autoStartEpsilon)) {
            result = this.autoMoveAndPlay.moveTo(startJointPosition, nodeTitle);
        } else {
            this.notifyPreparingToPlayProgram(program);
            result = this.generateScriptAndSendToController(program, startJointPosition);
        }
        Log.info((String)("Play program: " + result));
        return result;
    }

    private String buildNodeTitle(Pair<Integer, Positional> pair) {
        if (pair == null) {
            return "";
        }
        Positional positional = (Positional)pair.getSecond();
        String title = positional instanceof ProgramNodeContribution ? ((ProgramNodeContribution)positional).getTitle() : (positional instanceof AbstractProgramNode ? positional.toString() : null);
        return this.textResource.linePositionTitle((Integer)pair.getFirst(), title);
    }

    private void notifyPreparingToPlayProgram(ProgramRootNode program) {
        EventNotificationService.notify(PlayProgramListener.class, listener -> listener.preparingPlay(program));
    }

    private ProgramActionResult generateScriptAndSendToController(ProgramRootNode program, JointPositionVector startPosition) {
        GenerateAndSendScriptTask generateAndSendScriptTask = new GenerateAndSendScriptTask(program, startPosition);
        this.taskMonitor.runAndWait((Task)generateAndSendScriptTask);
        return generateAndSendScriptTask.getProgramActionResult();
    }

    private ProgramActionResult mergeResult(ProgramActionResult firstResult, ProgramActionResult secondResult) {
        if (firstResult != ProgramActionResult.SUCCESS) {
            return firstResult;
        }
        return secondResult;
    }

    public static class DisconnectedFromController
    extends ProgramControlError {
        private TextResource textResource = LanguagePack.getTextResource();

        public DisconnectedFromController() {
            super("Not connected to controller");
        }

        private ErrorMessage controllerIsCurrentlyNotRunning() {
            return new ErrorMessage(this.textResource.Error(), this.textResource.notConnectedToControllerPleaseRestartController());
        }

        @Override
        public void logAndInformUser() {
            LegacyURDialogCreator.showErrorDialog(this.controllerIsCurrentlyNotRunning());
            this.silentlyLog();
        }
    }

    private class GenerateAndSendScriptTask
    extends ParallelTask {
        private final ProgramRootNode program;
        private final JointPositionVector startPosition;
        private ProgramActionResult programActionResult;

        public GenerateAndSendScriptTask(ProgramRootNode program, JointPositionVector startPosition) {
            super(ProgramControl.this.textResource.startingProgram(), program.countNodes());
            this.programActionResult = ProgramActionResult.EXECUTION_ERROR;
            this.program = program;
            this.startPosition = startPosition;
        }

        public void run() {
            if (ProgramControl.this.sendControllerCommandLock.tryLock()) {
                try {
                    ScriptWriter writer = new ScriptWriter();
                    if (ProgramControl.this.programExecutor.isRealRobot()) {
                        this.program.generateScriptCode(writer);
                    } else {
                        this.program.generateScriptCode(writer, this.startPosition);
                    }
                    this.programActionResult = this.sendProgramCode(writer);
                }
                finally {
                    ProgramControl.this.sendControllerCommandLock.unlock();
                }
            } else {
                this.programActionResult = ProgramActionResult.ALREADY_PLAYING_PROGRAM;
            }
        }

        private ProgramActionResult sendProgramCode(ScriptWriter writer) {
            try {
                this.notifyProgramRequestedToPlay(this.program, writer);
                return this.executeProgram(writer);
            }
            catch (Exception e) {
                Log.error((String)"Could not send program code", (Throwable)e);
                return ProgramActionResult.EXECUTION_ERROR;
            }
        }

        private ProgramActionResult executeProgram(ScriptWriter writer) {
            if (ProgramControl.this.programExecutor.acceptScript(writer)) {
                return ProgramActionResult.SUCCESS;
            }
            return ProgramActionResult.EXECUTION_ERROR;
        }

        private void notifyProgramRequestedToPlay(ProgramRootNode program, ScriptWriter writer) {
            EventNotificationService.notify(PlayProgramListener.class, listener -> listener.playing(program, writer));
        }

        public ProgramActionResult getProgramActionResult() {
            return this.programActionResult;
        }
    }

    public static class IncompleteProgram
    extends ProgramControlError {
        private TextResource textResource = LanguagePack.getTextResource();

        public IncompleteProgram() {
            super("Program is incomplete");
        }

        public ErrorMessage unableToRunIncompleteProgram() {
            return new ErrorMessage(this.textResource.programNotCompleteTitle(), this.textResource.programNotCompleteMessage(), this.textResource.programNotCompleteSuggestion());
        }

        @Override
        public void logAndInformUser() {
            LegacyURDialogCreator.showErrorDialog(this.unableToRunIncompleteProgram());
            this.silentlyLog();
        }
    }

    public static class MissingProgram
    extends ProgramControlError {
        public MissingProgram() {
            super("Dashboard does not have a program");
        }

        @Override
        public void logAndInformUser() {
            this.silentlyLog();
        }
    }

    public static class ProgramControlError
    extends RuntimeException {
        public ProgramControlError(String message) {
            super(message);
        }

        public void silentlyLog() {
            Log.error((String)super.getMessage());
        }

        public void logAndInformUser() {
            this.silentlyLog();
        }
    }

    private class ProgramIsStopped
    implements Waiting.ItHappens {
        private ProgramIsStopped() {
        }

        public boolean itHappened() {
            return ProgramControl.this.getProgramState() == ProgramState.STOPPED;
        }
    }
}

