/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.program;

import com.ur.monitor.requirements.PlayProgramRequirement;
import com.ur.polyscope.viewfacade.program.ProgramActionResult;
import com.ur.swing.taskprogress.TaskMonitor;
import com.ur.util.concurrent.ParallelTask;
import com.ur.util.concurrent.Task;
import com.ur.view.program.ProgramExecutor;
import gui.program.ProgramRootNode;
import gui.program.calibration.KinematicConversion;
import gui.tools.dialogs.DialogInputStrategy;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;

public class ProgramControlPreparePlay {
    private final TaskMonitor taskMonitor;
    private final ProgramExecutor programExecutor;
    private final Set<PlayProgramRequirement> playProgramRequirements;

    @Inject
    public ProgramControlPreparePlay(TaskMonitor taskMonitor, ProgramExecutor programExecutor, Set<PlayProgramRequirement> playProgramRequirements) {
        this.taskMonitor = taskMonitor;
        this.programExecutor = programExecutor;
        this.playProgramRequirements = Collections.unmodifiableSet(playProgramRequirements);
    }

    public ProgramActionResult preparePlay(ProgramRootNode program) {
        if (this.getRobotStateResult() == ProgramActionResult.BAD_ROBOT_STATE) {
            return ProgramActionResult.BAD_ROBOT_STATE;
        }
        ProgramCorrectionParallelTask programCorrectionTask = new ProgramCorrectionParallelTask(program);
        new DialogInputStrategy().runWithProgress(this.taskMonitor, (Task)programCorrectionTask);
        if (programCorrectionTask.programCorrectionWasPerformed()) {
            return ProgramActionResult.SUCCESS;
        }
        this.programExecutor.releaseBreaksOnSecurityStopWhenSimulating();
        return ProgramActionResult.SUCCESS;
    }

    public ProgramActionResult getRobotStateResult() {
        if (this.programExecutor.isRealRobot()) {
            for (PlayProgramRequirement each : this.playProgramRequirements) {
                if (each.check()) continue;
                return ProgramActionResult.BAD_ROBOT_STATE;
            }
        }
        return ProgramActionResult.SUCCESS;
    }

    private static class ProgramCorrectionParallelTask
    extends ParallelTask {
        private boolean programCorrectionWasPerformed;
        private ProgramRootNode program;

        ProgramCorrectionParallelTask(ProgramRootNode program) {
            super("Preparing Program Correction", true);
            this.program = program;
        }

        public void run() {
            this.programCorrectionWasPerformed = KinematicConversion.convertProgram(this.program);
        }

        boolean programCorrectionWasPerformed() {
            return this.programCorrectionWasPerformed;
        }
    }
}

