/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.program;

import com.ur.monitor.RobotState;
import com.ur.monitor.model.JointPositionVector;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.simulation.RobotDeviceService;
import com.ur.util.logging.Log;
import com.ur.view.hmc.ControllerSocketSender;
import javax.inject.Inject;

public class ProgramExecutor {
    private RobotDeviceService robotDeviceService;
    private ControllerInterface controllerInterface;

    @Inject
    private ProgramExecutor(RobotDeviceService robotDeviceService, ControllerInterface controllerInterface) {
        this.robotDeviceService = robotDeviceService;
        this.controllerInterface = controllerInterface;
    }

    public void stopJoint() {
        ControllerSocketSender.sendStopJoint(1.5);
    }

    public boolean canExecute() {
        return this.controllerInterface.isConnected();
    }

    public boolean acceptScript(ScriptWriter writer) {
        try {
            this.controllerInterface.setUserProgramOnRobot(true);
            return this.controllerInterface.runScript(writer.generateScript());
        }
        catch (Exception e) {
            Log.error((String)"Could not send program code: ", (Throwable)e);
            this.controllerInterface.setUserProgramOnRobot(false);
            return false;
        }
    }

    public boolean stopProgram() {
        return ControllerSocketSender.sendStopProgram();
    }

    public boolean pauseProgram() {
        return ControllerSocketSender.sendPauseProgram();
    }

    public boolean resumeProgram() {
        return ControllerSocketSender.sendResumeProgram();
    }

    public void releaseBreaksOnSecurityStopWhenSimulating() {
        RobotState latestRobotState = RobotState.getLatestRobotState();
        if (this.robotDeviceService.isSimulated() && latestRobotState.securityStopped) {
            ControllerSocketSender.sendReleaseBrakes();
        }
    }

    public boolean isProgramRunning() {
        return RobotState.getLatestRobotState().programRunning;
    }

    public boolean isInkognito() {
        return "inkognito".equalsIgnoreCase(RobotState.getLatestRobotState().getCurrentProgramName());
    }

    public boolean isRealRobot() {
        RobotState latestRobotState = RobotState.getLatestRobotState();
        return latestRobotState.real;
    }

    public boolean stepProgram() {
        boolean result = ControllerSocketSender.sendStep();
        if (result) {
            result = ControllerSocketSender.sendResumeProgram();
        }
        return result;
    }

    public boolean mustMoveToLocationOnRealRobot(JointPositionVector startPosition, double epsilon) {
        return !startPosition.isUndefined() && this.robotDeviceService.isReal() && !this.isAtLocation(startPosition, epsilon);
    }

    private boolean isAtLocation(JointPositionVector startPosition, double epsilon) {
        return RobotState.getLatestRobotState().jointPosition.epsilonEquals(startPosition, epsilon);
    }
}

