/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.program;

import com.ur.log.logentry.robotmessage.LabelInfo;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.viewfacade.program.ProgramEventListener;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import com.ur.view.program.PlayProgramListener;
import com.ur.view.program.execution.ProgramTrackingInfoChangedListener;
import gui.installation.services.ProgramLookupService;
import gui.polyscope.program.ProgramTreeChangeObserver;
import gui.program.MainProgram;
import gui.program.ProgramRootNode;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ProgramTrackingInformation
implements ProgramTreeChangeObserver {
    private ProgramLookupService programLookupService;
    private AbstractProgramNode trackedThread;
    private Map<String, Integer> lastSeenNodeOnThreadMap = new HashMap<String, Integer>();

    @Inject
    public ProgramTrackingInformation(ProgramLookupService programLookupService) {
        this.programLookupService = programLookupService;
        EventNotificationService.register((Object)this, ProgramTreeChangeObserver.class, (Object)this);
        EventNotificationService.register((Object)this, PlayProgramListener.class, (Object)new PlayProgramListener(){

            @Override
            public void preparingPlay(ProgramRootNode program) {
                ProgramTrackingInformation.this.lastSeenNodeOnThreadMap.clear();
            }

            @Override
            public void playing(ProgramRootNode program, ScriptWriter scriptWriter) {
            }
        });
        EventNotificationService.register((Object)this, ProgramEventListener.class, (Object)new ProgramEventListener.Template(){

            public void onPreNewProgram() {
                ProgramTrackingInformation.this.trackedThread = null;
                ProgramTrackingInformation.this.lastSeenNodeOnThreadMap.clear();
            }
        });
    }

    @Override
    public void handleProgramTreeEvent(ProgramTreeChangeObserver.ProgramTreeEvent event) {
        if (event.type == ProgramTreeChangeObserver.Type.NODE_REMOVED && event.node.equals(this.getTrackedThread())) {
            this.trackedThread = this.getMainProgram();
        }
    }

    public void updateLastSeenNodeOnThreadMap(LabelInfo labelInfo) {
        for (LabelInfo.LabelMessage message : labelInfo.labelList) {
            this.lastSeenNodeOnThreadMap.put(message.threadName, message.id);
        }
    }

    public int getLastExecutingIdOnThread(String threadName) {
        ProgramRootNode programRoot;
        Integer id = this.lastSeenNodeOnThreadMap.get(threadName);
        if (id == null && (programRoot = this.programLookupService.getProgramRootNode()) != null && threadName.equals(programRoot.getMainProgram().toString())) {
            id = this.lastSeenNodeOnThreadMap.get("");
        }
        return id != null ? id : -1;
    }

    public AbstractProgramNode getTrackedThread() {
        if (this.trackedThread == null) {
            this.trackedThread = this.getMainProgram();
        }
        return this.trackedThread;
    }

    public void setTrackedThread(AbstractProgramNode trackedThread) {
        this.trackedThread = trackedThread;
        this.notifyTrackedThreadChanged(trackedThread);
    }

    private void notifyTrackedThreadChanged(final AbstractProgramNode trackedThread) {
        EventNotificationService.notify(ProgramTrackingInfoChangedListener.class, (NotificationStrategy)new NotificationStrategy<ProgramTrackingInfoChangedListener>(){

            public void notify(ProgramTrackingInfoChangedListener programTrackingInfoChangedListener) {
                programTrackingInfoChangedListener.trackedThreadChanged(trackedThread);
            }
        });
    }

    public void setTrackingOnMainThread() {
        this.trackedThread = this.getMainProgram();
        this.notifyTrackedThreadChanged(this.trackedThread);
    }

    private MainProgram getMainProgram() {
        ProgramRootNode programRootNode = this.programLookupService.getProgramRootNode();
        return programRootNode != null ? programRootNode.getMainProgram() : null;
    }
}

