/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.program;

import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.swing.JFrameUtils;
import com.ur.swing.SwingUtil;
import com.ur.util.Optional;
import com.ur.util.event.EventManager;
import com.ur.view.polyscope.persistence.program.LogTime;
import gui.main.PolyScopeStateListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;

public class ReportTextFieldsThatAreFocusable
implements PolyScopeStateListener {
    private static final Logger LOG = LogFactory.createLogger(ReportTextFieldsThatAreFocusable.class);

    @Inject
    public ReportTextFieldsThatAreFocusable(EventManager eventManager) {
        eventManager.addStrongListener(PolyScopeStateListener.class, (Object)this);
    }

    @Override
    public void onInit() {
    }

    @Override
    public void onReady() {
        new Thread(){

            @Override
            public void run() {
                try {
                    Optional polyScope = JFrameUtils.getApplicationMainFrame();
                    while (!polyScope.isPresent()) {
                        Thread.sleep(500L);
                        polyScope = JFrameUtils.getApplicationMainFrame();
                    }
                    ReportTextFieldsThatAreFocusable.this.iterateContainers((JFrame)polyScope.get());
                }
                catch (InterruptedException e) {
                    LOG.info("Interrupted", (Throwable)e);
                }
            }
        }.start();
    }

    private void iterateContainers(JFrame polyScope) {
        LogTime.startLog("Report all non-focusable");
        for (Component each : SwingUtil.getAllComponents((Container)polyScope, (Class[])new Class[]{JTextField.class})) {
            if (!(each instanceof JTextField) || !each.isFocusable()) continue;
            if (each.getName() == null) {
                LOG.warn("'{}' is not set to 'Focusable=false'", new Object[]{this.backTrackName(each)});
            } else {
                LOG.warn("'{}' is not set to 'Focusable=false'", new Object[]{each.getName()});
            }
            this.decorateField((JTextField)each);
        }
        LogTime.stopLog("Report all non-focusable", 50L);
    }

    private String backTrackName(Component component) {
        String result = " null ";
        component = component.getParent();
        while (component != null) {
            if (component.getName() != null) {
                result = " -> '" + component.getName() + "'" + result;
            }
            component = component.getParent();
        }
        return result;
    }

    private void decorateField(JTextField component) {
        JTextField textField = component;
        CompoundBorder newBorder = new CompoundBorder(BorderFactory.createLineBorder(Color.BLUE, 3), textField.getBorder());
        textField.setBorder(newBorder);
        textField.addPropertyChangeListener("border", new EnsureBorderStays(newBorder, textField));
    }

    private static class EnsureBorderStays
    implements PropertyChangeListener {
        private final CompoundBorder newBorder;
        private final JTextField textField;

        public EnsureBorderStays(CompoundBorder newBorder, JTextField textField) {
            this.newBorder = newBorder;
            this.textField = textField;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue() != this.newBorder) {
                this.textField.setBorder(this.newBorder);
            }
        }
    }
}

