/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.program.execution;

import com.ur.view.program.OverlayPainter;
import com.ur.view.program.execution.ProgramExecutionIndicatorAction;
import gui.polyscope.program.ProgramPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.inject.Inject;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class GotoExecutingNodeButton
extends JButton
implements OverlayPainter {
    private Rectangle bounds;
    private final ProgramPanel programPanel;
    private final ProgramExecutionIndicatorAction indicatorAction;

    @Inject
    public GotoExecutingNodeButton(final ProgramPanel programPanel, ProgramExecutionIndicatorAction action) {
        super((Action)((Object)action));
        this.programPanel = programPanel;
        this.bounds = this.extractBoundsFromIcon(action);
        this.indicatorAction = action;
        programPanel.setOverlayPainter(this);
        action.setProgramTree(programPanel.getProgramTree());
        Dimension size = new Dimension(this.bounds.width, this.bounds.height);
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                programPanel.repaint();
            }
        });
    }

    public Rectangle extractBoundsFromIcon(ProgramExecutionIndicatorAction action) {
        Icon icon = (Icon)action.getValue("SmallIcon");
        return new Rectangle(icon.getIconWidth(), icon.getIconHeight());
    }

    @Override
    public boolean isShowing() {
        return this.isEnabled() && this.programPanel.isShowing();
    }

    @Override
    public void paintOverlay(Graphics g) {
        if (this.isEnabled()) {
            JViewport viewport = this.programPanel.getViewport();
            Point viewportPos = SwingUtilities.convertPoint(viewport, viewport.getViewPosition(), (Component)((Object)this.programPanel));
            Point viewportLoc = viewport.getView().getLocation();
            int x = viewportPos.x + viewportLoc.x + viewport.getWidth() - this.getBounds().width - 10;
            int y = viewportPos.y + viewportLoc.y + viewport.getHeight() - this.getBounds().height - 10;
            this.setLocation(new Point(x, y));
            this.getIcon().paintIcon(viewport, g, x, y);
        }
    }

    @Override
    public boolean processMouseClickEvent(MouseEvent e) {
        if (this.isShowing() && this.withinMyBounds(e.getXOnScreen(), e.getYOnScreen())) {
            this.indicatorAction.goToExecutingNode();
            return true;
        }
        return false;
    }

    private boolean withinMyBounds(int x, int y) {
        return this.isWithinBounds(x, this.getLocationOnScreen().getX(), this.getLocationOnScreen().getX() + this.getBounds().getWidth()) && this.isWithinBounds(y, this.getLocationOnScreen().getY(), this.getLocationOnScreen().getY() + this.getBounds().getHeight());
    }

    private boolean isWithinBounds(double value, double lowerBound, double upperBound) {
        return value >= lowerBound && value <= upperBound;
    }

    @Override
    public Point getLocationOnScreen() {
        Point result = this.programPanel.getLocationOnScreen();
        result.translate(this.getX(), this.getY());
        return result;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }
}

