/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.program.execution;

import com.google.common.net.MediaType;
import com.ur.disk.Directories;
import com.ur.log.logentry.robotmessage.LabelInfo;
import com.ur.polyscope.flightrecorder.FlightRecorderProbe;
import com.ur.polyscope.flightrecorder.FlightRecorderTriggerType;
import com.ur.polyscope.flightrecorder.attachment.AttachmentCollector;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachment;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachmentFactory;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.PersistanceMetaData;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentification;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.version.urversion.URVersionProvider;
import com.ur.swing.SwingUtil;
import com.ur.util.logging.Log;
import com.ur.view.program.execution.PolyScopeMonitor;
import gui.installation.RobotInstallationLookupService;
import gui.polyscope.DashBoard;
import gui.program.ProgramRootNode;
import gui.program.ProgramRootNodeSave;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.inject.Provider;

public class PolyScopeDiagnosticsProbe
implements FlightRecorderProbe {
    private static final String HOME = System.getProperty("user.home");
    private final URVersionProvider urVersionProvider;
    private final RobotInstallationLookupService installationLookup;
    private final FlightRecorderAttachmentFactory attachmentFactory;
    private final Provider<RobotIdentification> robotIdentificationProvider;
    private PolyScopeMonitor monitor = null;

    @Inject
    public PolyScopeDiagnosticsProbe(URVersionProvider urVersionProvider, RobotInstallationLookupService installationLookup, FlightRecorderAttachmentFactory attachmentFactory, Provider<RobotIdentification> robotIdentificationProvider) {
        this.urVersionProvider = urVersionProvider;
        this.installationLookup = installationLookup;
        this.attachmentFactory = attachmentFactory;
        this.robotIdentificationProvider = robotIdentificationProvider;
    }

    public String getName() {
        return "PolyScope Probe";
    }

    public void write(PrintStream out) {
        RobotIdentification robotIdentification = (RobotIdentification)this.robotIdentificationProvider.get();
        out.print("Serial number: ");
        if (robotIdentification != null) {
            out.println(robotIdentification.getSerialNumber().getSerialNumber());
        } else {
            out.println("Not available");
        }
        String data = (String)SwingUtil.invokeAndWaitForAnswer((Callable)new GetInformationCallable());
        if (data != null) {
            out.print(data);
        } else {
            Log.error((String)"Some information is missing");
        }
        this.writeProgramIndicator(out);
    }

    public List<FlightRecorderAttachment> getFileAttachments() {
        AttachmentCollector r = new AttachmentCollector(this.attachmentFactory);
        r.collect(new File(HOME, "histogram.dat"), MediaType.PLAIN_TEXT_UTF_8.toString());
        r.collect(new File(HOME, "histogram.properties"), MediaType.PLAIN_TEXT_UTF_8.toString());
        List attachments = (List)SwingUtil.invokeAndWaitForAnswer((Callable)new GetAttachmentsCallable());
        if (attachments != null) {
            r.collectAll(attachments);
        } else {
            Log.error((String)"Filed while collecting attachment files");
        }
        return r.asList();
    }

    private void writeProgramIndicator(PrintStream out) {
        LabelInfo label = this.monitor != null ? this.monitor.getLatestProgramIndicatorLabel() : null;
        out.println("Latest Program Indicator: " + label);
    }

    public void start() {
        this.stop();
        this.monitor = new PolyScopeMonitor();
        this.monitor.init();
    }

    public void stop() {
        if (this.monitor != null) {
            this.monitor.dispose();
        }
    }

    public Set<FlightRecorderTriggerType> getApplicableReportTypes() {
        return EnumSet.allOf(FlightRecorderTriggerType.class);
    }

    private String getCurrentInstallationName() {
        Installation installation = this.installationLookup.getInstallation();
        if (installation == null) {
            return null;
        }
        return ((PersistanceMetaData)installation.getMetaData(PersistanceMetaData.class)).fileName();
    }

    private String getProgramNameOrNull() {
        ProgramRootNode p = DashBoard.getProgram();
        return p == null ? null : p.getName();
    }

    private String getProgramScriptOrNull() {
        try {
            ProgramRootNode node = DashBoard.getProgram();
            if (node != null) {
                ScriptWriter w = new ScriptWriter();
                node.generateScriptCodeWithCurrentInstallation(w);
                return w.toString();
            }
        }
        catch (Exception x) {
            Log.error((String)"Caught unexpected exception during script generation", (Throwable)x);
        }
        return null;
    }

    private byte[] getProgramURPOrNull() {
        try {
            ProgramRootNode node = DashBoard.getProgram();
            if (node != null) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ProgramRootNodeSave.saveURPToStream(node, os);
                return os.toByteArray();
            }
        }
        catch (Exception x) {
            Log.error((String)"Caught unexpected exception during urp generation", (Throwable)x);
        }
        return null;
    }

    private class GetAttachmentsCallable
    implements Callable<List<FlightRecorderAttachment>> {
        private GetAttachmentsCallable() {
        }

        @Override
        public List<FlightRecorderAttachment> call() {
            byte[] bytes;
            String script;
            String programName;
            AttachmentCollector r = new AttachmentCollector(PolyScopeDiagnosticsProbe.this.attachmentFactory);
            String installationName = PolyScopeDiagnosticsProbe.this.getCurrentInstallationName();
            if (installationName != null) {
                r.collect(new File(Directories.programs(), String.valueOf(installationName) + ".installation"), Integer.MAX_VALUE, MediaType.GZIP.toString());
                r.collect(new File(Directories.programs(), String.valueOf(installationName) + ".variables"), Integer.MAX_VALUE, MediaType.PLAIN_TEXT_UTF_8.toString());
            }
            if ((programName = PolyScopeDiagnosticsProbe.this.getProgramNameOrNull()) != null) {
                r.collect(new File(Directories.programs(), String.valueOf(PolyScopeDiagnosticsProbe.this.getProgramNameOrNull()) + ".urp"), Integer.MAX_VALUE, MediaType.GZIP.toString());
                r.collect(new File(Directories.programs(), String.valueOf(PolyScopeDiagnosticsProbe.this.getProgramNameOrNull()) + ".script"), Integer.MAX_VALUE, MediaType.PLAIN_TEXT_UTF_8.toString());
            }
            if ((script = PolyScopeDiagnosticsProbe.this.getProgramScriptOrNull()) != null && !script.isEmpty()) {
                r.collect(PolyScopeDiagnosticsProbe.this.attachmentFactory.getByteArrayAttachment(script.getBytes(), "polyscope.in.memory.program.script", MediaType.PLAIN_TEXT_UTF_8.toString()));
            }
            if ((bytes = PolyScopeDiagnosticsProbe.this.getProgramURPOrNull()) != null) {
                r.collect(PolyScopeDiagnosticsProbe.this.attachmentFactory.getByteArrayAttachment(bytes, "polyscope.in.memory.program.urp", MediaType.GZIP.toString()));
            }
            return r.asList();
        }
    }

    private class GetInformationCallable
    implements Callable<String> {
        private GetInformationCallable() {
        }

        @Override
        public String call() {
            return String.valueOf(this.getVersions()) + "Current Installation Name: " + PolyScopeDiagnosticsProbe.this.getCurrentInstallationName() + "\n" + "Current Program Name: " + PolyScopeDiagnosticsProbe.this.getProgramNameOrNull() + "\n" + "Current Program State: " + DashBoard.getProgramState() + "\n";
        }

        private String getVersions() {
            return "Version: " + PolyScopeDiagnosticsProbe.this.urVersionProvider.getMarketingVersion() + "\n" + "Build date: " + PolyScopeDiagnosticsProbe.this.urVersionProvider.getBuildDate() + "\n" + "Baseline: " + PolyScopeDiagnosticsProbe.this.urVersionProvider.getBaselineVersion() + "\n" + "Polyscope: " + PolyScopeDiagnosticsProbe.this.urVersionProvider.getPolyscopeVersion() + "\n" + "Controller: " + PolyScopeDiagnosticsProbe.this.urVersionProvider.getControllerVersion() + "\n" + "Firmware: " + PolyScopeDiagnosticsProbe.this.urVersionProvider.getFirmwareVersion() + "\n" + "Platform: " + PolyScopeDiagnosticsProbe.this.urVersionProvider.getPlatformVersion() + "\n";
        }
    }
}

