/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.program.execution;

import com.ur.log.logentry.robotmessage.LabelInfo;
import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.log.logentry.robotmessage.RobotMessageListener;
import com.ur.util.event.EventNotificationService;
import com.ur.view.constants.comm.RobotMessageType;
import java.util.concurrent.atomic.AtomicReference;

public class PolyScopeMonitor {
    private final AtomicReference<LabelInfo> labelInfo = new AtomicReference();
    private final RobotMessageListener listener = new RobotMessageListener(){

        public void handleRobotMessage(RobotMessage msg) {
            if (msg.type == RobotMessageType.PROGRAM_LABEL_THREADS) {
                PolyScopeMonitor.this.labelInfo.set(msg.getLabelinfo());
            }
        }
    };

    public void init() {
        EventNotificationService.register((Object)this, RobotMessageListener.class, (Object)this.listener);
    }

    public void dispose() {
        EventNotificationService.unregister((Object)this.listener);
    }

    LabelInfo getLatestProgramIndicatorLabel() {
        return this.labelInfo.get();
    }
}

