/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.program.execution;

import com.ur.log.logentry.robotmessage.LabelInfo;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.view.program.ProgramTrackingInformation;
import gui.installation.services.ProgramLookupService;
import gui.program.ProgramRootNode;
import javax.swing.tree.TreeNode;

public class ProgramExecutionID {
    public static final int INVALID_NODE_ID = -1;

    private ProgramExecutionID() {
    }

    public static int getExecutingId(ProgramLookupService programLookupService, ProgramTrackingInformation programTrackingInformation, LabelInfo labelInfo) {
        int result = -1;
        ProgramRootNode programRoot = programLookupService.getProgramRootNode();
        if (programRoot == null) {
            return result;
        }
        AbstractProgramNode trackedThread = programTrackingInformation.getTrackedThread();
        String threadName = trackedThread == null || trackedThread.equals(programRoot.getMainProgram()) ? "" : trackedThread.toString();
        for (LabelInfo.LabelMessage message : labelInfo.labelList) {
            if (!message.threadName.equals(threadName)) continue;
            result = ProgramExecutionID.findNewExecutionId(programLookupService, message.id);
            break;
        }
        return result;
    }

    private static int findNewExecutionId(ProgramLookupService programLookupService, int id) {
        TreeNode[] path;
        ProgramRootNode programRoot = programLookupService.getProgramRootNode();
        AbstractProgramNode currentNode = programRoot.getNode(id);
        if (currentNode == null) {
            return id;
        }
        TreeNode[] treeNodeArray = path = currentNode.getPath();
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            TreeNode node = treeNodeArray[n2];
            if (ProgramExecutionID.isTreeNotExpandable(node)) {
                return node instanceof AbstractProgramNode ? ((AbstractProgramNode)node).getId() : -1;
            }
            ++n2;
        }
        return id;
    }

    private static boolean isTreeNotExpandable(TreeNode node) {
        return node instanceof AbstractProgramNode && !((AbstractProgramNode)node).isTreeExpandable();
    }
}

