/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.program.execution;

import com.ur.log.logentry.robotmessage.LabelInfo;
import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.log.logentry.robotmessage.RobotMessageListener;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.ProgramModel;
import com.ur.polyscope.scriptwriter.ScriptGenerator;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.viewfacade.program.ProgramEventListener;
import com.ur.util.event.EventNotificationService;
import com.ur.view.constants.comm.RobotMessageType;
import com.ur.view.program.ProgramTrackingInformation;
import com.ur.view.program.execution.ProgramExecutionID;
import com.ur.view.program.execution.ProgramTrackingInfoChangedListener;
import gui.installation.services.ProgramLookupService;
import gui.polyscope.program.ProgramIndicatorView;
import gui.program.ProgramRootNode;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

@Singleton
class ProgramExecutionIndicator
extends MouseAdapter
implements RobotMessageListener,
ProgramTrackingInfoChangedListener {
    private final ProgramTrackingInformation programTrackingInformation;
    private ProgramIndicatorView programPanel;
    private AbstractProgramNode lastExecutingNode = null;
    private AbstractProgramNode userSelectedNode = null;
    private JTree tree;
    private ProgramLookupService programLookupService;

    @Inject
    public ProgramExecutionIndicator(ProgramLookupService programLookupService, ProgramTrackingInformation programTrackingInformation) {
        this.programLookupService = programLookupService;
        this.programTrackingInformation = programTrackingInformation;
        EventNotificationService.register((Object)this, RobotMessageListener.class, (Object)this);
        EventNotificationService.register((Object)this, ProgramEventListener.class, (Object)new ProgramEventListener.Template(){

            public void onPreNewProgram() {
                ProgramExecutionIndicator.this.lastExecutingNode = null;
                ProgramExecutionIndicator.this.clearUserSelection();
                ProgramExecutionIndicator.this.updateGotoExecutingNodeButton();
            }
        });
        EventNotificationService.register((Object)this, ProgramTrackingInfoChangedListener.class, (Object)this);
    }

    public void setProgramTree(JTree tree) {
        this.tree = tree;
        tree.addMouseListener(this);
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                ProgramExecutionIndicator.this.updateSelectionOnTree();
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                ProgramExecutionIndicator.this.updateSelectionOnTree();
            }
        });
    }

    public void updateSelectionOnTree() {
        if (this.lastExecutingNode == null) {
            return;
        }
        if (this.shouldSelectNode(this.userSelectedNode)) {
            this.userSelectedNode.setSelected();
        } else if (this.userSelectedNode == null && this.shouldSelectNode(this.lastExecutingNode)) {
            this.lastExecutingNode.setSelected();
        }
    }

    public void setIndicatorAction(ProgramIndicatorView programPanel) {
        this.programPanel = programPanel;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        TreePath selectedPath = this.tree.getPathForLocation(e.getX(), e.getY());
        if (selectedPath != null) {
            this.tree.setSelectionPath(selectedPath);
            this.userSelectedNode = (AbstractProgramNode)selectedPath.getLastPathComponent();
        }
        this.updateGotoExecutingNodeButton();
    }

    private boolean shouldSelectNode(AbstractProgramNode node) {
        return node != null && this.tree.isVisible(new TreePath(node.getPath()));
    }

    public void handleRobotMessage(RobotMessage robotMessage) {
        if (robotMessage.type == RobotMessageType.PROGRAM_LABEL_THREADS) {
            this.handleProgramLabelThreads(robotMessage.getLabelinfo());
        } else if (robotMessage.type == RobotMessageType.RUNTIME_EXCEPTION) {
            this.handleRuntimeException((ScriptWriter.ScriptPosition)robotMessage.extraData);
        }
    }

    private void handleProgramLabelThreads(LabelInfo labelInfo) {
        int id = ProgramExecutionID.getExecutingId(this.programLookupService, this.programTrackingInformation, labelInfo);
        this.programTrackingInformation.updateLastSeenNodeOnThreadMap(labelInfo);
        if (id != -1) {
            this.updateUI(id);
        }
    }

    private void handleRuntimeException(ScriptWriter.ScriptPosition scriptPosition) {
        ScriptGenerator scriptGenerator;
        ProgramRootNode programRootNode = this.programLookupService.getProgramRootNode();
        if (programRootNode != null && (scriptGenerator = programRootNode.getScriptGeneratorLookup().findScriptGenerator(scriptPosition)) != null) {
            scriptGenerator.setScriptError(scriptPosition);
        }
    }

    private void nodeChangedRecursive(ProgramModel programModel, AbstractProgramNode node) {
        AbstractProgramNode parent;
        programModel.nodeChanged((TreeNode)node);
        if (node != null && node.getParent() != null && node.getParent() instanceof AbstractProgramNode && (parent = (AbstractProgramNode)node.getParent()).getNodeType().isChildrenAllowed()) {
            this.nodeChangedRecursive(programModel, parent);
        }
    }

    private void updateUI(int executingId) {
        ProgramRootNode programRoot = this.programLookupService.getProgramRootNode();
        AbstractProgramNode executingNode = programRoot.getNode(executingId);
        if (executingNode != null) {
            if (this.lastExecutingNode != null) {
                this.lastExecutingNode.setExecuting(false);
            }
            executingNode.setExecuting(true);
            if (this.userSelectedNode == null) {
                executingNode.setSelected();
            } else {
                ProgramModel pm = programRoot.getProgramTreeModel();
                this.nodeChangedRecursive(pm, this.lastExecutingNode);
                this.nodeChangedRecursive(pm, executingNode);
                pm.makeVisible(executingNode);
            }
        }
        this.lastExecutingNode = executingNode;
        this.updateGotoExecutingNodeButton();
    }

    public AbstractProgramNode getLastExecutedProgramNode() {
        return this.lastExecutingNode;
    }

    public void clearUserSelection() {
        this.userSelectedNode = null;
    }

    protected void clearProgramExecutionState() {
        if (this.lastExecutingNode != null) {
            this.lastExecutingNode.setExecuting(false);
            this.lastExecutingNode = null;
            this.updateGotoExecutingNodeButton();
        }
    }

    private void updateGotoExecutingNodeButton() {
        if (this.programPanel != null) {
            this.programPanel.enableGotoExecutingNodeButton(this.lastExecutingNode != null && this.userSelectedNode != null);
        }
    }

    @Override
    public void trackedThreadChanged(AbstractProgramNode newTrackedThread) {
        int id = this.programTrackingInformation.getLastExecutingIdOnThread(newTrackedThread.toString());
        if (id != -1) {
            this.updateUI(id);
        }
    }
}

