/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.program.execution;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.resources.ViewImageResource;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.ActionDefinition;
import com.ur.view.program.execution.ProgramExecutionIndicator;
import gui.polyscope.program.ProgramIndicatorView;
import java.awt.event.ActionEvent;
import javax.inject.Inject;
import javax.swing.JTree;

class ProgramExecutionIndicatorAction
extends AbstractActionDefinition
implements ProgramIndicatorView {
    private ProgramExecutionIndicator executionIndicator;

    @Inject
    public ProgramExecutionIndicatorAction(ProgramExecutionIndicator executionIndicator) {
        this.executionIndicator = executionIndicator;
        this.putValue("SmallIcon", ViewImageResource.programGotoExecutingNode());
        this.putValue("Function", ActionDefinition.Function.TOOLBAR);
        this.putValue("HelpId", "gui:program_execution_indication");
        this.setEnabled(false);
    }

    public void setProgramTree(JTree tree) {
        this.executionIndicator.setProgramTree(tree);
        this.executionIndicator.setIndicatorAction(this);
    }

    public void goToExecutingNode() {
        AbstractProgramNode executingNode = this.executionIndicator.getLastExecutedProgramNode();
        if (executingNode != null) {
            this.executionIndicator.clearUserSelection();
            executingNode.setSelected();
            this.enableGotoExecutingNodeButton(false);
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.goToExecutingNode();
    }

    @Override
    public void enableGotoExecutingNodeButton(boolean enable) {
        if (this.isEnabled() != enable) {
            this.setEnabled(enable);
        }
    }
}

