/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.program.execution;

import com.google.common.net.MediaType;
import com.ur.lang.StringUtils;
import com.ur.lang.adt.Pair;
import com.ur.polyscope.flightrecorder.FlightRecorderProbe;
import com.ur.polyscope.flightrecorder.FlightRecorderTriggerType;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachment;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachmentFactory;
import com.ur.view.program.execution.ProgramExecutionProbeMonitor;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import javax.inject.Inject;

public class ProgramExecutionProbe
implements FlightRecorderProbe {
    private static final String PROGRAM_EXECUTION_FILENAME = "program_execution.txt";
    private final FlightRecorderAttachmentFactory factory;
    private ProgramExecutionProbeMonitor monitor;

    @Inject
    public ProgramExecutionProbe(FlightRecorderAttachmentFactory factory) {
        this.factory = factory;
    }

    public String getName() {
        return "Last Executed Nodes Probe";
    }

    public void write(PrintStream printStream) {
    }

    public List<FlightRecorderAttachment> getFileAttachments() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Previous Executed Program Nodes:\n");
        Map<String, Queue<Pair<Integer, String>>> latestIDs = this.monitor.getLatestIDs();
        for (Map.Entry<String, Queue<Pair<Integer, String>>> entry : latestIDs.entrySet()) {
            String threadName = "".equals(entry.getKey()) ? "main" : entry.getKey();
            stringBuilder.append(" Thread: " + threadName + "\n");
            for (Pair pair : entry.getValue()) {
                stringBuilder.append(String.valueOf(this.printItem((Pair<Integer, String>)pair)) + "\n");
            }
            stringBuilder.append("\n");
        }
        FlightRecorderAttachment attachment = null;
        try {
            attachment = this.factory.getByteArrayAttachment(stringBuilder.toString().getBytes("UTF-8"), PROGRAM_EXECUTION_FILENAME, MediaType.PLAIN_TEXT_UTF_8.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return Arrays.asList(attachment);
    }

    private String printItem(Pair<Integer, String> item) {
        return "  " + StringUtils.padLeftWith((String)Integer.toString((Integer)item.getFirst()), (String)" ", (int)4) + ": " + (String)item.getSecond();
    }

    public void start() {
        this.monitor = new ProgramExecutionProbeMonitor();
        this.monitor.init();
    }

    public void stop() {
        this.monitor.dispose();
    }

    public Set<FlightRecorderTriggerType> getApplicableReportTypes() {
        return EnumSet.of(FlightRecorderTriggerType.SOFTWARE_FAILURE, FlightRecorderTriggerType.CONTROLLER_REPORTED_ERROR);
    }
}

