/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.program.execution;

import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableMap;
import com.ur.lang.adt.Pair;
import com.ur.log.logentry.robotmessage.LabelInfo;
import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.log.logentry.robotmessage.RobotMessageListener;
import com.ur.polyscope.program.ProgramStateListener;
import com.ur.polyscope.program.monitor.ProgramState;
import com.ur.util.event.EventNotificationService;
import com.ur.view.constants.comm.RobotMessageType;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;

public class ProgramExecutionProbeMonitor
implements RobotMessageListener,
ProgramStateListener {
    private final Map<String, Queue<Pair<Integer, String>>> latestIDs = new HashMap<String, Queue<Pair<Integer, String>>>();
    private static final int NUMBER_OF_RETAINED_IDS = 15;

    public void init() {
        EventNotificationService.register((Object)this, RobotMessageListener.class, (Object)this);
        EventNotificationService.register((Object)this, ProgramStateListener.class, (Object)this);
    }

    public void dispose() {
        EventNotificationService.unregister((Object)this);
    }

    Map<String, Queue<Pair<Integer, String>>> getLatestIDs() {
        return ImmutableMap.copyOf(this.latestIDs);
    }

    public void handleRobotMessage(RobotMessage robotMessage) {
        if (robotMessage.type == RobotMessageType.PROGRAM_LABEL_THREADS) {
            this.recordAllThreadMessages(robotMessage.getLabelinfo());
        }
    }

    private void recordAllThreadMessages(LabelInfo labelInfo) {
        for (LabelInfo.LabelMessage message : labelInfo.labelList) {
            Object threadIDs;
            String threadName;
            String string = threadName = "".equals(message.threadName) ? "main" : message.threadName;
            if (!this.latestIDs.containsKey(threadName)) {
                threadIDs = EvictingQueue.create((int)15);
                this.latestIDs.put(threadName, (Queue<Pair<Integer, String>>)threadIDs);
            } else {
                threadIDs = this.latestIDs.get(threadName);
            }
            threadIDs.add(new Pair((Object)message.id, (Object)message.message));
        }
    }

    public void programStateChanged(ProgramState oldState, ProgramState newState) {
        if (newState == ProgramState.PLAYING) {
            this.latestIDs.clear();
        }
    }
}

