/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.program.linenumbers;

import com.ur.polyscope.program.ProgramStateHolder;
import com.ur.polyscope.program.ProgramStateListener;
import com.ur.polyscope.program.monitor.ProgramState;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.security.LockablePrivilegeLevel;
import com.ur.polyscope.security.LockableRestrictedPoint;
import com.ur.polyscope.security.Privileges;
import com.ur.polyscope.security.RestrictedPoint;
import com.ur.polyscope.viewfacade.program.ProgramEventListener;
import com.ur.resources.ViewImageResource;
import com.ur.security.Privilege;
import com.ur.security.PrivilegeLevelChangeListener;
import com.ur.util.event.EventNotificationService;
import com.ur.util.logging.Log;
import com.ur.view.program.PlayProgramListener;
import com.ur.view.program.linenumbers.BreakPointHitListener;
import com.ur.view.program.linenumbers.BreakPointModel;
import com.ur.view.program.linenumbers.BreakpointSynchronizationService;
import com.ur.view.program.linenumbers.NodeLineNumberCache;
import gui.polyscope.program.ProgramTreeChangeObserver;
import gui.program.ProgramRootNode;
import gui.tree.ProgramTreeProvider;
import java.awt.Image;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

@Singleton
public class BreakPointModelImpl
implements BreakPointModel,
BreakPointHitListener,
ProgramStateListener,
PlayProgramListener,
ProgramTreeChangeObserver,
PrivilegeLevelChangeListener<LockablePrivilegeLevel> {
    private final NodeLineNumberCache nodeLineNumberCache;
    private Set<AbstractProgramNode> breakPointNodesList;
    private final ProgramTreeProvider programTreeProvider;
    private BreakpointSynchronizationService breakpointSyncService;
    private final ProgramStateHolder programStateHolder;
    private String programName;
    private Privilege<LockablePrivilegeLevel> editProgramPrivilege;
    private int pausedOnLine = -1;

    @Inject
    public BreakPointModelImpl(ProgramTreeProvider treeProvider, BreakpointSynchronizationService brkpointSyncService, ProgramStateHolder stateHolder, Privileges privileges, NodeLineNumberCache nodeLineNumberCache) {
        this.nodeLineNumberCache = nodeLineNumberCache;
        this.breakPointNodesList = new HashSet<AbstractProgramNode>();
        this.programTreeProvider = treeProvider;
        this.breakpointSyncService = brkpointSyncService;
        this.programStateHolder = stateHolder;
        this.editProgramPrivilege = privileges.getPrivilege((RestrictedPoint)LockableRestrictedPoint.EDIT_PROGRAM);
        this.editProgramPrivilege.addLevelChangeListener((PrivilegeLevelChangeListener)this);
        EventNotificationService.register((Object)this, BreakPointHitListener.class, (Object)this);
        EventNotificationService.register((Object)this, ProgramStateListener.class, (Object)this);
        EventNotificationService.register((Object)this, PlayProgramListener.class, (Object)this);
        EventNotificationService.register((Object)this, ProgramTreeChangeObserver.class, (Object)this);
        EventNotificationService.register((Object)this, ProgramEventListener.class, (Object)new ProgramEventListener.Template(){

            public void onPostNewProgram() {
                if (BreakPointModelImpl.this.breakpointSyncService.isSyncActive()) {
                    BreakPointModelImpl.this.breakpointSyncService.stopSync();
                }
                BreakPointModelImpl.this.clearAllBreakPoints();
            }
        });
    }

    private void clearAllBreakPoints() {
        this.breakPointNodesList.clear();
    }

    private JTree getTree() {
        return this.programTreeProvider.getTree();
    }

    @Override
    public boolean hasBreakpoint(int line) {
        if (line == -1) {
            return false;
        }
        AbstractProgramNode node = this.getNodeById(line);
        if (node != null) {
            return this.breakPointNodesList.contains(node);
        }
        return false;
    }

    private AbstractProgramNode getNodeById(int lineNumber) {
        return this.nodeLineNumberCache.getNodeByLineNumber(lineNumber);
    }

    @Override
    public void setBreakpoint(int line, boolean value) {
        if (line == -1) {
            return;
        }
        AbstractProgramNode node = this.getNodeById(line);
        if (node == null) {
            return;
        }
        if (value) {
            this.breakPointNodesList.add(node);
        } else {
            this.breakPointNodesList.remove(node);
        }
        this.getTree().repaint();
        this.breakpointSyncService.syncUpdate(node.getId(), value);
    }

    @Override
    public boolean canSetBreakPoint(int line) {
        if (line == -1) {
            return false;
        }
        AbstractProgramNode node = this.getNodeById(line);
        return node != null && node.canPauseOnNode();
    }

    public List<Integer> getBreakpointData() {
        ArrayList<Integer> breakpointLabels = new ArrayList<Integer>(this.breakPointNodesList.size());
        for (AbstractProgramNode programNode : this.breakPointNodesList) {
            if (!this.isNodeInProgramTree(programNode)) continue;
            Log.debug((String)("breakpoint set at " + programNode.getId()));
            breakpointLabels.add(programNode.getId());
        }
        return breakpointLabels;
    }

    private boolean isNodeInProgramTree(AbstractProgramNode programNode) {
        Object[] nodePathArray = programNode.getPath();
        if (!this.getTree().getModel().getRoot().equals(nodePathArray[0])) {
            return false;
        }
        TreePath path = new TreePath(nodePathArray);
        boolean isNodeHidden = false;
        if (!this.getTree().isVisible(path)) {
            Object[] objectArray = nodePathArray;
            int n = nodePathArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object parentNode = objectArray[n2];
                AbstractProgramNode node = (AbstractProgramNode)parentNode;
                if (!node.isTreeExpandable()) {
                    Log.debug((String)("Found a non expandable parent " + node.toString()));
                    isNodeHidden = true;
                    break;
                }
                ++n2;
            }
        }
        return !isNodeHidden;
    }

    @Override
    public Image getBreakPointImage(int line) {
        if (this.pausedOnLine == line) {
            return ((ImageIcon)ViewImageResource.breakpointHit()).getImage();
        }
        return ((ImageIcon)ViewImageResource.breakpoint()).getImage();
    }

    @Override
    public void preparingPlay(ProgramRootNode program) {
    }

    @Override
    public void playing(ProgramRootNode program, ScriptWriter scriptWriter) {
        this.programName = program.getScriptName();
        if (this.editProgramPrivilege.getLevel() == LockablePrivilegeLevel.ALLOWED) {
            if (this.breakpointSyncService.isSyncActive()) {
                this.breakpointSyncService.stopSync();
            }
            this.breakpointSyncService.startSync(this.programName, this.getBreakpointData());
        }
    }

    public void programStateChanged(ProgramState from, ProgramState to) {
        if (to == ProgramState.STOPPED) {
            this.breakpointSyncService.stopSync();
        }
        if (to != ProgramState.PAUSED) {
            this.pausedOnLine = -1;
        }
    }

    @Override
    public void handleProgramTreeEvent(ProgramTreeChangeObserver.ProgramTreeEvent event) {
        if (event.type == ProgramTreeChangeObserver.Type.NODE_REMOVED && event.node.isUnregisterProgramReferencesOnDelete()) {
            this.breakPointNodesList.remove(event.node);
        }
    }

    public void levelChanged(LockablePrivilegeLevel oldPrivilegeLevel, LockablePrivilegeLevel newPrivilegeLevel) {
        Log.debug((String)("Edit Program Privilege changed from " + oldPrivilegeLevel + " to " + newPrivilegeLevel));
        if (newPrivilegeLevel != LockablePrivilegeLevel.ALLOWED) {
            this.breakpointSyncService.stopSync();
        } else if (this.programStateHolder.getProgramState().isActive()) {
            this.breakpointSyncService.startSync(this.programName, this.getBreakpointData());
        }
    }

    @Override
    public void breakPointHit(int labelID) {
        this.pausedOnLine = labelID;
    }
}

