/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.program.linenumbers;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.swing.extensible.PostTreeCellRenderer;
import com.ur.view.program.linenumbers.CurrentBreakPointModelProvider;
import gui.program.position.WaypointNode;
import gui.program.until.UntilNode;
import java.awt.Color;
import java.awt.Component;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTree;

public class BreakpointIndicatorRenderer
implements PostTreeCellRenderer {
    private static final JLabel DUMMY_LABEL = new JLabel();
    private final CurrentBreakPointModelProvider breakPointModelProvider;

    @Inject
    public BreakpointIndicatorRenderer(CurrentBreakPointModelProvider breakPointModelProvider) {
        this.breakPointModelProvider = breakPointModelProvider;
    }

    public Component getTreeCellRendererComponent(Component component, JTree jTree, Object programNode, boolean selected, boolean expanded, boolean leaf, int row, boolean hasfocus) {
        int bottomMargin;
        JLabel renderer = this.getRendererAsJLabel(component);
        AbstractProgramNode node = (AbstractProgramNode)programNode;
        int topMargin = programNode instanceof UntilNode || programNode instanceof WaypointNode ? 2 : 0;
        int n = bottomMargin = programNode instanceof UntilNode || programNode instanceof WaypointNode ? 0 : 2;
        if (this.breakPointModelProvider.getCurrentBreakPointModel().hasBreakpoint(node.getId())) {
            renderer.setBorder(BorderFactory.createMatteBorder(bottomMargin, 0, topMargin, 0, Color.RED));
        } else {
            renderer.setBorder(BorderFactory.createEmptyBorder(bottomMargin, 0, topMargin, 0));
        }
        return component;
    }

    private JLabel getRendererAsJLabel(Component component) {
        return component instanceof JLabel ? (JLabel)component : DUMMY_LABEL;
    }
}

